/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.LinearPrediction;
import agd.predict.SimpleFootprint;
import agd.predict.SimpleTrackable;
import agd.predict.TargetPrediction;
import agd.util.Compass;
import agd.util.Coord;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class CircularPrediction
extends TargetPrediction {
    static LinearPrediction linearPrediction = new LinearPrediction();

    CircularPrediction() {
    }

    public Coord predictTarget(List recentFootprints, long time) {
        Coord predictedPosition = null;
        if (recentFootprints.size() >= 2) {
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint lastFp = (Footprint)lit.previous();
            Footprint lastBut1Fp = (Footprint)lit.previous();
            double sampleTime = lastFp.getTime() - lastBut1Fp.getTime();
            double headingChange = lastFp.getHeading().getDegrees() - lastBut1Fp.getHeading().getDegrees();
            double headingChangeRate = headingChange / sampleTime;
            long extrapolatePeriod = time - lastFp.getTime();
            predictedPosition = headingChangeRate > 1.0E-5 ? CircularPrediction.circularPrediction(lastFp.getPosition(), lastFp.getHeading(), lastFp.getVelocity(), headingChangeRate, extrapolatePeriod) : linearPrediction.predictTarget(recentFootprints, time);
        } else {
            predictedPosition = linearPrediction.predictTarget(recentFootprints, time);
        }
        return predictedPosition;
    }

    public String toString() {
        return "Circular";
    }

    static Coord circularPrediction(Coord startPos, Compass startHeading, double velocity, double headingChangeRate, long duration) {
        double rStartHeading = startHeading.getRadians();
        double radius = velocity / Math.toRadians(headingChangeRate);
        double totalHeadingChange = (double)duration * headingChangeRate;
        double rEndHeading = Math.toRadians(startHeading.getDegrees() + totalHeadingChange);
        double x = startPos.getX() + Math.cos(rStartHeading) * radius - Math.cos(rEndHeading) * radius;
        double y = startPos.getY() + Math.sin(rEndHeading) * radius - Math.sin(rStartHeading) * radius;
        return new Coord(x, y);
    }

    public static String testRetrospective() {
        StringBuffer o = new StringBuffer(200);
        o.append("Test rig for retrospective circular prediction\n");
        Coord p100 = new Coord(565.4112881527515, 357.6780780933602);
        Compass h100 = new Compass(35.515544217976164);
        double v100 = 5.0;
        Coord p101 = new Coord(568.7417083787773, 361.4074615703009);
        Compass h101 = new Compass(41.765544217976164);
        Coord p120 = new Coord(645.2337333810557, 341.9588698643169);
        Compass h120 = new Compass(160.51554421797616);
        Coord p150 = new Coord(555.9188462747406, 321.9791501949336);
        Compass h150 = new Compass(348.01554421797647);
        Coord p200 = new Coord(575.8258559835239, 290.8627418167341);
        Coord p250 = new Coord(612.2162595058626, 284.5177881221976);
        Coord p300 = new Coord(641.4792503388288, 307.0610193327895);
        Coord p400 = new Coord(619.6205418101752, 371.0528097931259);
        Coord p500 = new Coord(557.7773714095091, 343.70002822242463);
        SimpleFootprint fp1 = new SimpleFootprint(100L, p100, h100, 5.0);
        SimpleFootprint fp2 = new SimpleFootprint(101L, p101, h101, 5.0);
        SimpleFootprint fp20 = new SimpleFootprint(120L, p120, h120, 5.0);
        SimpleFootprint fp50 = new SimpleFootprint(150L, p150, h150, 5.0);
        LinkedList<SimpleFootprint> footprints = new LinkedList<SimpleFootprint>();
        footprints.add(fp1);
        footprints.add(fp2);
        SimpleTrackable target = new SimpleTrackable(footprints);
        Coord est150 = TargetPrediction.CIRCULAR.predictTarget(target, 150L);
        Coord est200 = TargetPrediction.CIRCULAR.predictTarget(target, 200L);
        Coord est250 = TargetPrediction.CIRCULAR.predictTarget(target, 250L);
        Coord est300 = TargetPrediction.CIRCULAR.predictTarget(target, 300L);
        Coord est400 = TargetPrediction.CIRCULAR.predictTarget(target, 400L);
        Coord est500 = TargetPrediction.CIRCULAR.predictTarget(target, 500L);
        o.append("@ 150 estimated " + est150 + ", real " + p150 + ", out by " + p150.distanceTo(est150) + "\n");
        o.append("@ 200 should be " + est200 + ", real " + p200 + ", out by " + p200.distanceTo(est200) + "\n");
        o.append("@ 250 should be " + est250 + ", real " + p250 + ", out by " + p250.distanceTo(est250) + "\n");
        o.append("@ 300 should be " + est300 + ", real " + p300 + ", out by " + p300.distanceTo(est300) + "\n");
        o.append("@ 400 should be " + est400 + ", real " + p400 + ", out by " + p400.distanceTo(est400) + "\n");
        o.append("@ 500 should be " + est500 + ", real " + p500 + ", out by " + p500.distanceTo(est500) + "\n");
        o.append("\nRetrospective prediction\n");
        o.append("------------------------\n");
        o.append("Only 2 footprints\n");
        Coord rest500 = TargetPrediction.CIRCULAR.retrospectivelyPredict(target, 500L, 300L);
        o.append("Pridiction at 300, gives " + rest500 + " by 500, out by " + rest500.distanceTo(p500) + "\n");
        footprints = new LinkedList();
        footprints.add(fp1);
        footprints.add(fp2);
        footprints.add(fp20);
        footprints.add(fp50);
        o.append("4 footprints\n");
        rest500 = TargetPrediction.CIRCULAR.retrospectivelyPredict(target, 500L, 300L);
        o.append("Prediction at 300, gives " + rest500 + " by 500, out by " + rest500.distanceTo(p500) + "\n");
        return o.toString();
    }

    public static void main(String[] argv) {
        System.out.println(CircularPrediction.testRetrospective());
    }
}

