/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.intel.ChessBoard;
import agd.util.ChessStrategy;
import agd.util.Coord;
import agd.util.CoordInt;
import agd.util.RobotInformation;
import agd.util.World;
import java.util.Vector;

public class ChessStrategy1v1
extends ChessStrategy {
    public ChessStrategy1v1(RobotInformation ri) {
        super(ri, 0);
    }

    public Coord calcDesiredPoint() {
        Coord size = World.getBattleFieldSize();
        return new Coord(size.getX() / 2.0, size.getY() / 2.0);
    }

    Vector getCandidateDestinationSquares(CoordInt currentPos) {
        Vector candidates = this.board.getNeighbours(currentPos, 1);
        candidates.add(this.board.getSquare(currentPos));
        return candidates;
    }

    private Vector getNSEWNeighbours(CoordInt pos) {
        return this.getNSEWNeighbours(pos, 1);
    }

    private Vector getNSEWNeighbours(CoordInt pos, int step) {
        Vector<ChessBoard.ChessSquare> neighbours = new Vector<ChessBoard.ChessSquare>(4);
        CoordInt temp = new CoordInt(pos.getX() - 1, pos.getY());
        if (this.board.containsSquare(temp)) {
            neighbours.add(this.board.getSquare(temp));
        }
        if (this.board.containsSquare(temp = new CoordInt(pos.getX() + 1, pos.getY()))) {
            neighbours.add(this.board.getSquare(temp));
        }
        if (this.board.containsSquare(temp = new CoordInt(pos.getX(), pos.getY() - 1))) {
            neighbours.add(this.board.getSquare(temp));
        }
        if (this.board.containsSquare(temp = new CoordInt(pos.getX(), pos.getY() + 1))) {
            neighbours.add(this.board.getSquare(temp));
        }
        return neighbours;
    }
}

