/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Bearing;
import shrub.Location;
import shrub.QuadrantAdjust;
import shrub.ShrubMath;

public class Heading {
    public static final Heading ZERO = new Heading(0.0);
    public static final Heading PLUS_90 = new Heading(90.0);
    public static final Heading PLUS_180 = new Heading(180.0);
    public static final Heading PLUS_270 = new Heading(270.0);
    private final double mHeading;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public static final Heading valueOf(double hdngVal) {
        Heading answer = new Heading(hdngVal);
        return answer;
    }

    private Heading(double hdngVal) {
        this.mHeading = this.Normalise(hdngVal);
    }

    private double Normalise(double hdngVal) {
        boolean done = false;
        double answer = hdngVal;
        while (!done) {
            if (answer >= 360.0) {
                answer -= 360.0;
                continue;
            }
            if (answer < 0.0) {
                answer += 360.0;
                continue;
            }
            done = true;
        }
        return answer;
    }

    public double Get() {
        return this.mHeading;
    }

    public static Heading valueOfAdjust(Heading hdng, double delta) {
        Heading answer = new Heading(hdng.Get() + delta);
        return answer;
    }

    public static Heading valueOfAdjust(Heading hdng, Bearing brng) {
        Heading answer = new Heading(hdng.Get() + brng.Get());
        return answer;
    }

    public static Heading valueOfFlip(Heading hdng) {
        Heading answer = new Heading(hdng.Get() + 180.0);
        return answer;
    }

    public static Heading valueOfFlip(double hdng) {
        Heading answer = new Heading(hdng + 180.0);
        return answer;
    }

    public static Heading valueOfFromTo(Location fromLocn, Location toLocn) {
        Heading answer = null;
        double deltaX = toLocn.GetX() - fromLocn.GetX();
        double deltaY = toLocn.GetY() - fromLocn.GetY();
        double absDeltaX = Math.abs(deltaX);
        double absDeltaY = Math.abs(deltaY);
        if (absDeltaX <= 0.5 && absDeltaY <= 0.5) {
            answer = ZERO;
        } else if (absDeltaX <= 0.5 && deltaY <= -0.5) {
            answer = PLUS_180;
        } else if (absDeltaX <= 0.5 && deltaY >= 0.5) {
            answer = ZERO;
        } else if (absDeltaY <= 0.5 && deltaX <= -0.5) {
            answer = PLUS_270;
        } else if (absDeltaY <= 0.5 && deltaX >= 0.5) {
            answer = PLUS_90;
        } else {
            double radAngle = Math.atan(absDeltaX / absDeltaY);
            double degAngle = Math.toDegrees(radAngle);
            if (deltaX >= 0.5 && deltaY >= 0.5) {
                answer = Heading.valueOf(degAngle);
            } else if (deltaX >= 0.5 && deltaY <= -0.5) {
                answer = Heading.valueOf(180.0 - degAngle);
            } else if (deltaX <= -0.5 && deltaY <= -0.5) {
                answer = Heading.valueOf(180.0 + degAngle);
            } else if (deltaX <= -0.5 && deltaY >= 0.5) {
                answer = Heading.valueOf(360.0 - degAngle);
            }
        }
        return answer;
    }

    public double InlineComponent(Heading objHdng, double objValue) {
        double answer = 0.0;
        Bearing objRelBrng = Bearing.valueOfFromTo(this, objHdng);
        QuadrantAdjust qAdj = QuadrantAdjust.valueOf(objRelBrng.Get());
        double adjThetaDegY = qAdj.GetAdjThetaDegY();
        int adjSenseY = qAdj.GetAdjSenseY();
        answer = (double)adjSenseY * ShrubMath.Cos(adjThetaDegY) * objValue;
        return answer;
    }

    public double CrossComponent(Heading objHdng, double objValue) {
        double answer = 0.0;
        Bearing objRelBrng = Bearing.valueOfFromTo(this, objHdng);
        QuadrantAdjust qAdj = QuadrantAdjust.valueOf(objRelBrng.Get());
        double adjThetaDegY = qAdj.GetAdjThetaDegY();
        int adjSenseX = qAdj.GetAdjSenseX();
        answer = (double)adjSenseX * ShrubMath.Sin(adjThetaDegY) * objValue;
        return answer;
    }

    public Bearing toBearing() {
        Bearing answer = Bearing.valueOf(this.mHeading);
        return answer;
    }

    public String toString() {
        String answer = dp2.format(this.mHeading);
        return answer;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

