/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.GunPhysics;
import shrub.Heading;
import shrub.Location;
import shrub.MHTracker;
import shrub.Phasor;
import shrub.RadarInstruction;
import shrub.RadarMgr1v1;
import shrub.RadarModeAPI;
import shrub.RadarModeCSL;
import shrub.RadarModeNOP;
import shrub.RadarModePTL;
import shrub.RadarModeTOL;
import shrub.RobotDataStore;
import shrub.Sighting;

public class RadarMgrMelee
implements RadarModeAPI {
    private final RadarModeAPI mRadarModeNOP;
    private final RadarModeAPI mRadarModeCSL;
    private final RadarModeAPI mRadarModeTOL;
    private final RadarModeAPI mRadarModePTL;
    private final RadarMgr1v1 mRadarMgr1v1;
    private final MHTracker mTrackerRef;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private final GunPhysics mGunPhysics = GunPhysics.getInstance();

    public RadarMgrMelee(MHTracker trackerRef) {
        this.mTrackerRef = trackerRef;
        this.mRadarModeNOP = new RadarModeNOP();
        this.mRadarModeCSL = new RadarModeCSL(45.0);
        double[] tspArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};
        Phasor trackScanPhasor = new Phasor(tspArray);
        this.mRadarModePTL = new RadarModePTL(45.0, 15.0, trackScanPhasor);
        this.mRadarModeTOL = new RadarModeTOL(45.0, 15.0);
        this.mRadarMgr1v1 = new RadarMgr1v1(this.mTrackerRef);
    }

    public RadarInstruction GenerateInstruction() {
        int numFreshTargets = this.mTrackerRef.GetNumFreshTargets();
        boolean haveLockOn = this.mTrackerRef.HasLockOn();
        long numOthers = this.mDataStore.getNumOthers();
        Location radarLocn = this.mDataStore.getMyLocn();
        Heading radarHdng = this.mDataStore.getMyRadarHdng();
        long currentTime = this.mDataStore.getCurrentTime();
        RadarModeAPI radarModeInUse = this.mRadarModeNOP;
        if (numOthers <= 1L) {
            radarModeInUse = this.mRadarMgr1v1;
        } else if (!haveLockOn) {
            radarModeInUse = this.mRadarModeCSL;
        } else if ((long)numFreshTargets < numOthers) {
            Sighting currentTarget = this.mTrackerRef.GetCurrentTarget();
            ((RadarModePTL)this.mRadarModePTL).SetTargetLocn(currentTarget.GetLocation());
            radarModeInUse = this.mRadarModePTL;
        } else {
            Location tgtLocn = Location.ZERO_ZERO;
            if (this.mGunPhysics.howLongUntilICanFire() >= 5L) {
                int index = this.mTrackerRef.GetOldestTargetIndex();
                Sighting oldestTgt = this.mTrackerRef.GetTargetByIndex(index);
                tgtLocn = oldestTgt.GetLocation();
            } else {
                Sighting currentTarget = this.mTrackerRef.GetCurrentTarget();
                tgtLocn = currentTarget.GetLocation();
            }
            ((RadarModeTOL)this.mRadarModeTOL).SetTargetLocn(tgtLocn);
            radarModeInUse = this.mRadarModeTOL;
        }
        RadarInstruction radarInstruct = radarModeInUse.GenerateInstruction();
        return radarInstruct;
    }

    public void Resynchronise() {
        this.mRadarModeNOP.Resynchronise();
        this.mRadarModeCSL.Resynchronise();
        this.mRadarModeTOL.Resynchronise();
        this.mRadarModePTL.Resynchronise();
        this.mRadarMgr1v1.Resynchronise();
    }
}

