/*
 * Decompiled with CFR 0.152.
 */
package dk.tactics;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.config.Avoid;
import dk.config.Circle;
import dk.config.Config;
import dk.config.Dodge2;
import dk.config.JitteredAvoidDodge;
import dk.tactics.Tactics;
import java.util.ArrayList;
import robocode.DeathEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class HistogramDuel
extends Tactics {
    protected Config currentConfig;
    protected int startScore;
    protected int startPenalty;

    public void setEnemyHistogram(Enemy e) {
        ArrayList<Config> configs = new ArrayList<Config>();
        configs.add(new Circle());
        configs.add(new Dodge2());
        configs.add(new JitteredAvoidDodge());
        e.meleeConfigHistogram = new Histogram(configs);
        int i = 0;
        int c = configs.size();
        while (i < c) {
            e.meleeConfigHistogram.recordSuccess(i);
            ++i;
        }
    }

    public void doStartRound(Base robot) {
        robot.setConfig(new Avoid());
    }

    public void setTarget(Base r, Enemy e) {
        if (this.currentConfig == null && e != null) {
            if (e.meleeConfigHistogram == null) {
                this.setEnemyHistogram(e);
            }
            Histogram.Bucket b = e.meleeConfigHistogram.getRandomBucket();
            b.recordUse();
            this.currentConfig = (Config)b.getObject();
            r.setConfig(this.currentConfig);
            this.startScore = r.getScoreThisRound();
            this.startPenalty = r.getPenaltyThisRound();
            ((Robot)r).out.println("using " + this.currentConfig);
        }
        super.setTarget(r, e);
    }

    public void onScannedRobot(Base robot, ScannedRobotEvent e) {
        super.onScannedRobot(robot, e);
        Enemy newTarget = robot.getEnemyController().getEnemy(e.getName());
        if (this.target_ == null || !this.target_.isAlive()) {
            this.setTarget(robot, newTarget);
        }
    }

    public void scoreConfig(Base r, Enemy e) {
        int scoreNow = r.getScoreThisRound();
        int penaltyNow = r.getPenaltyThisRound();
        int score = scoreNow - this.startScore;
        int penalty = penaltyNow - this.startPenalty;
        ((Robot)r).out.println("score = " + score + " penalty = " + penalty);
        if (score > 75) {
            if (score > 100) {
                if (score > 140) {
                    e.meleeConfigHistogram.recordSuccess(this.currentConfig);
                }
                e.meleeConfigHistogram.recordSuccess(this.currentConfig);
            }
            e.meleeConfigHistogram.recordSuccess(this.currentConfig);
        } else {
            if (score < 40) {
                e.meleeConfigHistogram.recordFailure(this.currentConfig);
                if (score < 20) {
                    e.meleeConfigHistogram.recordFailure(this.currentConfig);
                }
            }
            e.meleeConfigHistogram.recordFailure(this.currentConfig);
        }
        if (penalty < 60) {
            e.meleeConfigHistogram.recordSuccess(this.currentConfig);
        } else {
            e.meleeConfigHistogram.recordFailure(this.currentConfig);
        }
        ((Robot)r).out.println("CONFIG STATS");
        e.meleeConfigHistogram.printStats(((Robot)r).out);
    }

    public void onRobotDeath(Base robot, RobotDeathEvent e) {
        super.onRobotDeath(robot, e);
        Enemy deadRobot = robot.getEnemyController().getEnemy(e.getName());
        if (deadRobot == this.target_) {
            this.setTarget(robot, null);
        }
        this.scoreConfig(robot, deadRobot);
    }

    public void onDeath(Base robot, DeathEvent e) {
        super.onDeath(robot, e);
        if (this.target_ != null) {
            this.scoreConfig(robot, this.target_);
        }
    }
}

