/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer;

import java.util.ArrayList;
import java.util.List;
import jbot.tracer.Wave;
import jbot.util.MathUtil;
import jbot.util.Vector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    static final int VEL_SMOOTH_FRAMES = 5;
    static final double NEW_SMOOTH_VEL_FACTOR = 0.2;
    static final double OLD_SMOOTH_VEL_FACTOR = 0.8;
    static final int ACC_SMOOTH_FRAMES = 5;
    static final double NEW_SMOOTH_ACC_FACTOR = 0.2;
    static final double OLD_SMOOTH_ACC_FACTOR = 0.8;
    static final int ANGLEVEL_SMOOTH_FRAMES = 4;
    static final double NEW_SMOOTH_ANGLEVEL_FACTOR = 0.25;
    static final double OLD_SMOOTH_ANGLEVEL_FACTOR = 0.75;
    static final int MAX_HISTORY_SIZE = 200;
    public List<Wave> mWavesList = new ArrayList<Wave>();
    protected boolean mIsLocked = false;
    protected ArrayList<Data> mHistory = new ArrayList();
    protected long mLastTime = 0L;
    protected long mRecentTime = 0L;
    protected double mDeltaTime = 0.0;
    protected double mSpeed = 0.0;
    protected double mAcceleration = 0.0;
    protected Vector2 mDirection = Vector2.UP.clone();
    protected double mAngleVel = 0.0;
    protected double mSmoothSpeed = 0.0;
    protected double mSmoothAcc = 0.0;
    protected double mSmoothAngleVel = 0.0;
    protected double mRecentVelSignChangeTime = 0.0;
    protected int mRecentVelSign = 0;
    protected int mLastVelSign = 0;
    protected Vector2 mPosition = new Vector2();
    protected Vector2 mRelativePos = new Vector2();
    protected double mEnergy = 100.0;
    protected double mEnergyRatio = 1.0;
    protected double mRelativeEnergy = 0.0;
    protected double mGunHeat = 0.0;
    protected double mAvgBulletPower = 0.0;
    protected int mBulletsFired = 0;
    protected int mBulletsHitedBy = 0;

    public long getRecentTime() {
        return this.mRecentTime;
    }

    public double getDeltaTime() {
        return this.mDeltaTime;
    }

    public double getSpeed() {
        return this.mSpeed;
    }

    public Vector2 getVelocity() {
        return this.mDirection.clone().multiply(this.mSpeed);
    }

    public double getAcceleration() {
        return this.mAcceleration;
    }

    public Vector2 getDirection() {
        return this.mDirection.clone();
    }

    public double getDirectionAngle() {
        return this.mDirection.getAngle();
    }

    public double getAngleVel() {
        return this.mAngleVel;
    }

    public double getSmoothSpeed() {
        return this.mSmoothSpeed;
    }

    public double getSmoothAcc() {
        return this.mSmoothAcc;
    }

    public double getSmoothAngleVel() {
        return this.mSmoothAngleVel;
    }

    public Vector2 getPosition() {
        return this.mPosition.clone();
    }

    public Vector2 getRelativePos() {
        return this.mRelativePos.clone();
    }

    public double getEnergy() {
        return this.mEnergy;
    }

    public double getEnergyRatio() {
        return this.mEnergyRatio;
    }

    public double getRelativeEnergy() {
        return this.mRelativeEnergy;
    }

    public double getGunHeat() {
        return this.mGunHeat;
    }

    public int getRecentVelSign() {
        return this.mRecentVelSign;
    }

    public double getRecentVelSignChangeTime() {
        return this.mRecentVelSignChangeTime;
    }

    public boolean isVelSignChanged() {
        return this.mLastVelSign != this.mRecentVelSign;
    }

    public int getBulletsFired() {
        return this.mBulletsFired;
    }

    public int getBulletsHitedBy() {
        return this.mBulletsHitedBy;
    }

    Wave getLastWave() {
        if (this.mWavesList.isEmpty()) {
            return null;
        }
        return this.mWavesList.get(this.mWavesList.size() - 1);
    }

    public boolean isLocked() {
        return this.mIsLocked;
    }

    public void updateTime(long recentTime) {
        if (recentTime > this.mRecentTime) {
            this.mLastTime = this.mRecentTime;
            this.mRecentTime = recentTime;
            this.mDeltaTime = this.mRecentTime - this.mLastTime;
        }
    }

    void updateMovement(double velocity, Vector2 direction) {
        double lastVelocity = this.mSpeed;
        this.mSpeed = velocity;
        this.mSmoothSpeed = 0.8 * this.mSmoothSpeed + 0.2 * this.mSpeed;
        this.mLastVelSign = this.mRecentVelSign;
        if (MathUtil.cmp(this.mSpeed, 0.0) != 0) {
            if (this.mRecentVelSign != 0 && (double)this.mRecentVelSign * this.mSpeed < 0.0) {
                this.mRecentVelSignChangeTime = this.mRecentTime;
            }
            this.mRecentVelSign = this.mSpeed > 0.0 ? 1 : -1;
        }
        Vector2 lastDirection = this.mDirection;
        this.mDirection = direction.clone();
        this.mAngleVel = lastDirection.getAngleTo(this.mDirection) / this.mDeltaTime;
        this.mSmoothAngleVel = 0.75 * this.mSmoothAngleVel + 0.25 * this.mAngleVel;
        this.mAcceleration = (this.mSpeed - lastVelocity) / this.mDeltaTime;
        this.mSmoothAcc = 0.8 * this.mSmoothAcc + 0.2 * this.mAcceleration;
    }

    void updatePosition(Vector2 position, Vector2 relativePos) {
        this.mPosition = position.clone();
        this.mRelativePos = relativePos.clone();
    }

    void updateEnergy(double targetEnergy, double relativeTargetEnergy, double gunHeat) {
        this.mEnergy = targetEnergy;
        if (relativeTargetEnergy != 0.0) {
            this.mEnergyRatio = targetEnergy / relativeTargetEnergy;
        }
        this.mRelativeEnergy = targetEnergy - relativeTargetEnergy;
        this.mGunHeat = gunHeat;
    }

    public void estimatedFrame(double deltaTime) {
        if (deltaTime < 0.0) {
            return;
        }
        this.mGunHeat -= 0.1 * deltaTime;
        if (this.mGunHeat < 0.0) {
            this.mGunHeat = 0.0;
        }
    }

    public int timeToHistoryIndex(long time) {
        if (time < 1L) {
            time = 1L;
        }
        if (time > this.mRecentTime) {
            time = this.mRecentTime;
        }
        int timeShift = (int)(this.mRecentTime - time);
        int index = this.mHistory.size() - 1 - timeShift;
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public Data getHistoryAgo(int timeAgo) {
        long searchTime = this.mRecentTime - (long)timeAgo;
        return this.getHistoryAt(searchTime);
    }

    public Data getHistoryAt(long searchTime) {
        Data data;
        if (this.mHistory.size() < 1) {
            return null;
        }
        try {
            data = this.mHistory.get(this.timeToHistoryIndex(searchTime));
        }
        catch (IndexOutOfBoundsException e) {
            data = null;
        }
        return data;
    }

    public ArrayList<Data> getHistory() {
        return this.mHistory;
    }

    public int getHistoryEntriesBefore(long time) {
        int index = this.timeToHistoryIndex(time);
        return index;
    }

    public int getHistorySize() {
        return this.mHistory.size();
    }

    public Data getRecentData() {
        return this.getHistoryAgo(0);
    }

    void updateHistory() {
        long lastHistoryTime;
        if (this.mHistory.size() > 0 && this.mRecentTime - (lastHistoryTime = this.mHistory.get(this.mHistory.size() - 1).getTime()) > 1L) {
            while (lastHistoryTime < this.mRecentTime - 1L) {
                this.mHistory.add(new Data(this.mSpeed, this.mAcceleration, this.mAngleVel, this.mPosition.clone(), this.mDirection.clone(), lastHistoryTime));
                ++lastHistoryTime;
            }
        }
        this.mHistory.add(new Data(this.mSpeed, this.mAcceleration, this.mAngleVel, this.mPosition.clone(), this.mDirection.clone(), this.mRecentTime));
        if (this.mHistory.size() > 200) {
            this.mHistory.remove(0);
        }
    }

    public static class Data {
        protected double mSpeed;
        protected double mAcceleration;
        protected double mAngleSpeed;
        protected Vector2 mPosition;
        protected Vector2 mDirection;
        protected long mTime;

        public Data(double v, double d, double w, Vector2 pos, Vector2 dir, long t) {
            this.mSpeed = v;
            this.mAcceleration = d;
            this.mAngleSpeed = w;
            this.mPosition = pos;
            this.mDirection = dir;
            this.mTime = t;
        }

        public double getSpeed() {
            return this.mSpeed;
        }

        public double getAcceleration() {
            return this.mAcceleration;
        }

        public double getAngleSpeed() {
            return this.mAngleSpeed;
        }

        public Vector2 getPosition() {
            return this.mPosition.clone();
        }

        public Vector2 getDirection() {
            return this.mDirection.clone();
        }

        public Vector2 getVelocity() {
            return this.mDirection.clone().multiply(this.mSpeed);
        }

        public double getDirectionAngle() {
            return this.mDirection.getAngle();
        }

        public long getTime() {
            return this.mTime;
        }
    }
}

