/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbot.tracer.Ray;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.Vector2;
import robocode.Rules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wave {
    public ArrayList<Ray> mRaysList = new ArrayList();
    private long mShotTime;
    protected Vector2 mShotPos;
    protected Vector2 mDirToTarget;
    private double mSpeed;
    private double mDamage;
    private double mPower;
    private boolean mRealBullet;
    private double mDistToTarget;
    private double mTraveledDistance;
    private List<Double> mEscapeAngles = null;

    public Wave(long shotTime, long currTime, Vector2 shotPos, Vector2 destPos, double power, boolean realBullet) {
        this.mShotTime = shotTime;
        this.mShotPos = shotPos.clone();
        this.mDirToTarget = destPos.clone().sub(this.mShotPos);
        this.mDistToTarget = this.mDirToTarget.getLength();
        this.mDirToTarget.normalize();
        this.mPower = power;
        this.mDamage = Rules.getBulletDamage((double)this.mPower);
        this.mSpeed = Rules.getBulletSpeed((double)this.mPower);
        this.mRealBullet = realBullet;
        this.mTraveledDistance = (double)(currTime - this.mShotTime) * this.mSpeed;
    }

    public void addRay(Ray ray) {
        ray.mAngleToWaveDir = ray.mDirection.getAngleTo(this.mDirToTarget);
        int i = 0;
        Ray r = null;
        ListIterator<Ray> ri = this.mRaysList.listIterator(0);
        while (ri.hasNext()) {
            r = ri.next();
            if (ray.mAngleToWaveDir < r.mAngleToWaveDir) break;
            ++i;
        }
        this.mRaysList.add(i, ray);
    }

    protected void updateTraveledDistance(double deltaTime) {
        if (this.mEscapeAngles != null) {
            this.mEscapeAngles.clear();
            this.mEscapeAngles = null;
        }
        this.mTraveledDistance += deltaTime * this.mSpeed;
    }

    public boolean isOverField() {
        return this.mTraveledDistance > 800.0;
    }

    public double getDistanceTo(Vector2 pos, long time) {
        Vector2 v = pos.clone();
        v.sub(this.mShotPos);
        return v.getLength() - (double)(time - this.mShotTime) * this.mSpeed;
    }

    public long getShotTime() {
        return this.mShotTime;
    }

    public Vector2 getShotPos() {
        return this.mShotPos.clone();
    }

    public double getSpeed() {
        return this.mSpeed;
    }

    public Vector2 getDirToTarget() {
        return this.mDirToTarget.clone();
    }

    public double getDamage() {
        return this.mDamage;
    }

    public double getPower() {
        return this.mPower;
    }

    public double getTraveledDistance() {
        return this.mTraveledDistance;
    }

    public double getDistToTarget() {
        return this.mDistToTarget;
    }

    public boolean isRealBullet() {
        return this.mRealBullet;
    }

    public Ray getRayBy(TracerTechnique tech) {
        for (Ray r : this.mRaysList) {
            if (r.mTechnique != tech) continue;
            return r;
        }
        return null;
    }

    public List<Double> getEscapeAnglesList() {
        if (this.mEscapeAngles == null) {
            double minAngleDiff = this.mTraveledDistance > 100.0 ? Math.atan(60.0 / this.mTraveledDistance) : Math.PI;
            this.mEscapeAngles = new ArrayList<Double>();
            if (!this.mRaysList.isEmpty()) {
                Ray ray = this.mRaysList.get(0);
                this.mEscapeAngles.add(ray.mDirection.getAngle() + minAngleDiff);
                ray = this.mRaysList.get(this.mRaysList.size() - 1);
                this.mEscapeAngles.add(ray.mDirection.getAngle() - minAngleDiff);
            }
            if (this.mRaysList.size() >= 2) {
                ListIterator<Ray> ri0 = this.mRaysList.listIterator(0);
                ListIterator<Ray> ri1 = this.mRaysList.listIterator(1);
                while (ri0.hasNext() && ri1.hasNext()) {
                    Ray r0 = ri0.next();
                    Ray r1 = ri1.next();
                    double angleBetween = r0.mDirection.getAngleTo(r1.mDirection);
                    if (Math.abs(angleBetween) < minAngleDiff) continue;
                    this.mEscapeAngles.add(r0.mDirection.getAngle() + angleBetween / 2.0);
                }
            }
        }
        return this.mEscapeAngles;
    }
}

