/*
 * Decompiled with CFR 0.152.
 */
package jbot.util;

import jbot.util.MathUtil;
import robocode.util.Utils;

public class Vector2 {
    private double NOT_UPTODATE = -1.0;
    public static final Vector2 UP = new Vector2(0.0, 1.0);
    public static final Vector2 RIGHT = new Vector2(1.0, 0.0);
    public static final Vector2 BOTTOM = new Vector2(0.0, -1.0);
    public static final Vector2 LEFT = new Vector2(-1.0, 0.0);
    private double x;
    private double y;
    private double r;
    private double a;

    public Vector2(Vector2 b) {
        this.x = b.x;
        this.y = b.y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public Vector2(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public Vector2() {
        this.x = 0.0;
        this.y = 0.0;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public Vector2(double _a) {
        this.x = 0.0;
        this.y = 1.0;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
        this.setAngle(_a);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double _x) {
        this.x = _x;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public void setY(double _y) {
        this.y = _y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
    }

    public Vector2 setLength(double length) {
        if (MathUtil.cmp(length, 0.0) == 0) {
            length = 0.0;
            this.a = this.NOT_UPTODATE;
        }
        this.normalize();
        if (length < 0.0) {
            this.invert();
            length = Math.abs(length);
        }
        this.r = length;
        this.x *= this.r;
        this.y *= this.r;
        return this;
    }

    public double getLength() {
        if (MathUtil.cmp(this.r, this.NOT_UPTODATE) == 0) {
            this.r = Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return this.r;
    }

    public double getDistanceTo(Vector2 b) {
        double dx = this.x - b.x;
        double dy = this.y - b.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getAngleTo(Vector2 b) {
        return Utils.normalRelativeAngle((double)(b.getAngle() - this.getAngle()));
    }

    public Vector2 rotate(double radians) {
        this.setAngle(this.getAngle() + radians);
        return this;
    }

    public Vector2 rotateByHalfPiLeft() {
        double oldx = this.x;
        this.x = -this.y;
        this.y = oldx;
        if (this.a != this.NOT_UPTODATE) {
            this.a -= 1.5707963267948966;
        }
        return this;
    }

    public Vector2 rotateByHalfPiRight() {
        double oldx = this.x;
        this.x = this.y;
        this.y = -oldx;
        if (this.a != this.NOT_UPTODATE) {
            this.a += 1.5707963267948966;
        }
        return this;
    }

    public Vector2 setAngle(double radians) {
        double len = this.getLength();
        this.x = Math.sin(radians %= Math.PI * 2) * len;
        this.y = Math.cos(radians) * len;
        this.a = radians;
        return this;
    }

    public double getAngle() {
        if (MathUtil.cmp(this.a, this.NOT_UPTODATE) == 0) {
            double len = this.getLength();
            if (MathUtil.cmp(len, 0.0) == 0) {
                this.a = this.NOT_UPTODATE;
            } else {
                this.a = Math.acos(this.y / len);
                if (this.x < 0.0) {
                    this.a = Math.PI * 2 - this.a;
                }
            }
        }
        return this.a;
    }

    public Vector2 multiply(double multiplier) {
        this.x *= multiplier;
        this.y *= multiplier;
        if (MathUtil.cmp(this.r, this.NOT_UPTODATE) != 0) {
            this.r *= Math.abs(multiplier);
        }
        if (multiplier < 0.0) {
            this.a = this.NOT_UPTODATE;
        }
        return this;
    }

    public double dot(Vector2 b) {
        return this.x * b.x + this.y * b.y;
    }

    public Vector2 add(Vector2 b) {
        this.x += b.x;
        this.y += b.y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
        return this;
    }

    public Vector2 sub(Vector2 b) {
        this.x -= b.x;
        this.y -= b.y;
        this.a = this.NOT_UPTODATE;
        this.r = this.NOT_UPTODATE;
        return this;
    }

    public Vector2 invert() {
        this.x = -this.x;
        this.y = -this.y;
        if (this.a != this.NOT_UPTODATE) {
            this.a = (this.a + Math.PI) % 360.0;
        }
        return this;
    }

    public Vector2 normalize() {
        double len = this.getLength();
        if (MathUtil.cmp(len, 0.0) != 0) {
            this.x /= len;
            this.y /= len;
            this.r = 1.0;
        }
        return this;
    }

    public Vector2 clone() {
        return new Vector2(this.x, this.y);
    }

    public void copyOf(Vector2 source) {
        this.x = source.getX();
        this.y = source.getY();
        this.r = source.getLength();
        this.a = source.getAngle();
    }
}

