/*
 * Decompiled with CFR 0.152.
 */
package ds;

import ds.BulletV4;
import ds.Case;
import ds.EnemyV4;
import ds.Point2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OoV4
extends AdvancedRobot {
    static double[] speedRecords = new double[3];
    static Point2D[] posRecords = new Point2D[3];
    static final int dataLength = 27;
    static double[][] data = new double[6][27];
    int largeurMap;
    int hauteurMap;
    int mode;
    int method;
    double PI;
    EnemyV4 target;
    double firePower;
    Vector balles;
    Vector vagues;
    double[][] map;
    int bestAngularOffset;

    public void run() {
        int i = 0;
        while (i < 3) {
            OoV4.speedRecords[i] = 0.0;
            OoV4.posRecords[i] = new Point2D(0.0, 0.0);
            ++i;
        }
        this.target = new EnemyV4();
        this.target.distance = 100000.0;
        this.target.energy = 500.0;
        this.setColors(Color.darkGray, Color.green, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.turnRadarRightRadians((double)2 * this.PI);
        double posX = this.getX();
        double posY = this.getY();
        while (true) {
            posX = this.getX();
            posY = this.getY();
            this.updateBalles();
            this.updateMap();
            switch (this.mode) {
                case 1: {
                    this.doMovement();
                    this.doFirePower();
                    this.doScanner();
                    this.doFire();
                    this.doGun();
                    break;
                }
                case 0: {
                    this.doMovement();
                    this.doScanner();
                }
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyV4 IAmTheTarget = new EnemyV4();
        IAmTheTarget.x = posRecords[0].getX();
        IAmTheTarget.y = posRecords[0].getY();
        IAmTheTarget.head = this.getHeadingRadians();
        IAmTheTarget.speed = speedRecords[1];
        IAmTheTarget.distance = e.getDistance();
        OoV4.speedRecords[2] = speedRecords[1];
        OoV4.speedRecords[1] = speedRecords[0];
        OoV4.speedRecords[0] = this.getVelocity();
        OoV4.posRecords[2] = posRecords[1];
        OoV4.posRecords[1] = posRecords[0];
        OoV4.posRecords[0] = new Point2D(this.getX(), this.getY());
        if (e.getDistance() < this.target.distance || this.target.name == e.getName()) {
            if (e.getVelocity() != 0.0) {
                this.method = 0;
                this.target.direction = e.getVelocity() * Math.sin(e.getHeadingRadians() - e.getBearingRadians() - this.getHeadingRadians());
                this.target.direction /= Math.abs(this.target.direction);
            } else {
                this.method = 1;
            }
            double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % ((double)2 * this.PI);
            this.target.name = e.getName();
            this.target.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
            this.target.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
            this.target.bearing = e.getBearingRadians();
            this.target.head = e.getHeadingRadians();
            this.target.ctime = this.getTime();
            this.target.speed = e.getVelocity();
            this.target.distance = e.getDistance();
            if (this.target.energy - e.getEnergy() <= (double)3 && this.target.energy - e.getEnergy() > 0.0) {
                long time = this.getTime() + (long)((int)(this.target.distance / (20.0 - (double)3 * (this.target.energy - e.getEnergy()))));
                BulletV4 tmpBullet = new BulletV4();
                tmpBullet.x = this.target.x;
                tmpBullet.y = this.target.y;
                tmpBullet.time = this.getTime();
                tmpBullet.speed = 20.0 - (double)3 * (this.target.energy - e.getEnergy());
                tmpBullet.head = this.absbearing(this.target.x, this.target.y, IAmTheTarget.guessX(-2L), IAmTheTarget.guessY(-2L));
                tmpBullet.depX = this.target.x;
                tmpBullet.depY = this.target.y;
                tmpBullet.method = 2;
                tmpBullet.x = tmpBullet.guessX(this.getTime() + 1L);
                tmpBullet.y = tmpBullet.guessY(this.getTime() + 1L);
                this.balles.add(tmpBullet);
                tmpBullet = new BulletV4();
                tmpBullet.x = this.target.x;
                tmpBullet.y = this.target.y;
                tmpBullet.time = this.getTime();
                tmpBullet.speed = 20.0 - (double)3 * (this.target.energy - e.getEnergy());
                int travelTime = (int)(this.target.distance / tmpBullet.speed);
                tmpBullet.head = this.absbearing(this.target.x, this.target.y, IAmTheTarget.guessX(travelTime - 2), IAmTheTarget.guessY(travelTime - 2));
                tmpBullet.depX = this.target.x;
                tmpBullet.depY = this.target.y;
                tmpBullet.method = 1;
                tmpBullet.x = tmpBullet.guessX(this.getTime() + 1L);
                tmpBullet.y = tmpBullet.guessY(this.getTime() + 1L);
                this.balles.add(tmpBullet);
            }
            this.target.energy = e.getEnergy();
            if (this.target.energy <= 0.0) {
                this.mode = 0;
            } else if (this.target.energy > 0.0) {
                this.mode = 1;
            }
        }
        IAmTheTarget.ctime = 0L;
    }

    public void updateMap() {
        int tY;
        int tX;
        int j;
        int i = 0;
        while (i < this.largeurMap) {
            j = 0;
            while (j < this.hauteurMap) {
                this.map[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.largeurMap) {
            j = 0;
            while (j < this.hauteurMap) {
                if (i == 0 || i == this.largeurMap - 1 || j == 0 || j == this.hauteurMap - 1) {
                    this.setCoef(i, j, 10.0, 4);
                    this.setCoef(i, j, 1000.0, 30);
                }
                ++j;
            }
            ++i;
        }
        this.setCoef(this.largeurMap / 2, this.hauteurMap / 2, 4, 4);
        if (this.target.distance < 10000.0) {
            tX = (int)((double)this.largeurMap * this.target.x / this.getBattleFieldWidth());
            tY = (int)((double)this.hauteurMap * this.target.y / this.getBattleFieldHeight());
            if (this.mode == 0) {
                this.setCoef(tX, tY, -200.0, 3);
                this.setCoef(tX, tY, -40.0, 1);
            } else {
                this.setCoef(tX, tY, 20.0, 1);
                this.setCoef(tX, tY, 80.0, 6);
            }
        }
        String aPrinter = "";
        int k = 0;
        while (k < this.balles.size()) {
            BulletV4 tmpBullet = (BulletV4)this.balles.elementAt(k);
            BulletV4 tmpBullet2 = new BulletV4(tmpBullet);
            tmpBullet2.time = this.getTime();
            long deltaTime = 2;
            tX = (int)((double)this.largeurMap * tmpBullet.x / this.getBattleFieldWidth());
            tY = (int)((double)this.hauteurMap * tmpBullet.y / this.getBattleFieldHeight());
            this.setCoef(tX, tY, 150.0, 8);
            int i2 = 1;
            while (tmpBullet2.x > 0.0 && tmpBullet2.x < this.getBattleFieldWidth() && tmpBullet2.y > 0.0 && tmpBullet2.y < this.getBattleFieldHeight()) {
                tmpBullet2.x = tmpBullet.guessX(this.getTime() + (long)i2 * deltaTime);
                tmpBullet2.y = tmpBullet.guessY(this.getTime() + (long)i2 * deltaTime);
                tX = (int)((double)this.largeurMap * tmpBullet2.x / this.getBattleFieldWidth());
                tY = (int)((double)this.hauteurMap * tmpBullet2.y / this.getBattleFieldHeight());
                double nvCoef = 100 - 2 * i2;
                if (nvCoef < 0.0) {
                    nvCoef = 0.0;
                }
                this.setCoef(tX, tY, nvCoef, 10);
                ++i2;
            }
            ++k;
        }
    }

    public void updateBalles() {
        BulletV4 tmpBullet;
        int nbElts = this.balles.size();
        Point2D tmpPoint = new Point2D();
        Point2D tmpPoint2 = new Point2D(this.getX(), this.getY());
        int i = 0;
        while (i < nbElts) {
            tmpBullet = (BulletV4)this.balles.elementAt(i);
            tmpBullet.x = tmpBullet.guessX(this.getTime());
            tmpBullet.y = tmpBullet.guessY(this.getTime());
            tmpBullet.time = this.getTime();
            ++i;
        }
        i = 0;
        while (i < nbElts) {
            tmpBullet = (BulletV4)this.balles.elementAt(i);
            if (tmpBullet.x < 0.0 || tmpBullet.x > this.getBattleFieldWidth() || tmpBullet.y < 0.0 || tmpBullet.y > this.getBattleFieldHeight()) {
                this.balles.remove(i);
                --i;
                --nbElts;
            } else {
                tmpPoint.x = tmpBullet.depX;
                tmpPoint.y = tmpBullet.depY;
                Point2D point2D = new Point2D(tmpBullet.x, tmpBullet.y);
                if (tmpPoint.distance(point2D) > tmpPoint.distance(tmpPoint2) + 30.0) {
                    this.balles.remove(i);
                    --i;
                    --nbElts;
                }
            }
            ++i;
        }
        nbElts = this.vagues.size();
        int i2 = 0;
        while (i2 < nbElts) {
            tmpBullet = (BulletV4)this.vagues.elementAt(i2);
            tmpBullet.x = tmpBullet.guessX(this.getTime());
            tmpBullet.y = tmpBullet.guessY(this.getTime());
            tmpBullet.time = this.getTime();
            ++i2;
        }
        i2 = 0;
        while (i2 < nbElts) {
            tmpBullet = (BulletV4)this.vagues.elementAt(i2);
            if (tmpBullet.x < 0.0 || tmpBullet.x > this.getBattleFieldWidth() || tmpBullet.y < 0.0 || tmpBullet.y > this.getBattleFieldHeight()) {
                OoV4.data[tmpBullet.distanceIndex][tmpBullet.indexOnWave] = OoV4.rollingAvg(data[tmpBullet.distanceIndex][tmpBullet.indexOnWave], 0.0, 0.05);
                this.vagues.remove(i2);
                --i2;
                --nbElts;
            }
            Point2D tmpPt = new Point2D(tmpBullet.x, tmpBullet.y);
            Point2D point2D = new Point2D(this.target.x, this.target.y);
            if (tmpPt.distance(point2D) < 25.0) {
                OoV4.data[tmpBullet.distanceIndex][tmpBullet.indexOnWave] = OoV4.rollingAvg(data[tmpBullet.distanceIndex][tmpBullet.indexOnWave], 1.0, 0.05);
                this.vagues.remove(i2);
                --i2;
                --nbElts;
            }
            ++i2;
        }
    }

    void doFire() {
        if (this.getGunHeat() == 0.0 && this.getEnergy() > this.firePower && this.target.distance < 1000.0) {
            if (this.method == 0) {
                int distanceIndex = (int)Math.round(Math.sqrt(this.target.distance / 40.0));
                int i = 0;
                while (i < 27) {
                    if (data[distanceIndex][i] > data[distanceIndex][this.bestAngularOffset]) {
                        this.bestAngularOffset = i;
                    }
                    BulletV4 tmpBullet = new BulletV4();
                    tmpBullet.x = this.getX();
                    tmpBullet.y = this.getY();
                    tmpBullet.time = this.getTime();
                    tmpBullet.speed = 20.0 - (double)3 * this.firePower;
                    tmpBullet.head = this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y) + this.target.direction * (((double)i - 13.0) / 26.0 * (double)3 / (double)4);
                    tmpBullet.distanceIndex = distanceIndex;
                    tmpBullet.indexOnWave = i++;
                    this.vagues.add(tmpBullet);
                }
            }
            this.setFire(this.firePower);
        }
    }

    static double rollingAvg(double value, double newEntry, double weighting) {
        return (value + newEntry * weighting) / (1.0 + weighting);
    }

    private final void goTo(Point2D point) {
        Point2D location = new Point2D(this.getX(), this.getY());
        double distance = location.distance(point);
        double angle = Utils.normalRelativeAngle((double)(location.absbearing(point) - this.getHeadingRadians()));
        if (Math.abs(angle) > this.PI / (double)2) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= this.PI) : (angle += this.PI);
        }
        this.setTurnRightRadians(angle);
        this.setAhead(distance);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.name) {
            this.target.distance = 10000.0;
        }
    }

    public void onWin(WinEvent e) {
        this.stop();
        while (this.getX() - this.getBattleFieldWidth() / (double)2 > 10.0 || this.getY() - this.getBattleFieldHeight() / (double)2 > 10.0) {
            this.goTo(new Point2D(this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() / (double)2));
            this.execute();
        }
        this.turnLeft(this.getHeading());
        this.turnGunLeft(this.getGunHeading());
        this.turnRadarLeft(this.getRadarHeading());
        while (true) {
            this.setTurnRight(10.0);
            this.setAhead(1000.0);
            this.execute();
            this.setTurnLeft(10.0);
            this.setAhead(-1000.0);
            this.execute();
        }
    }

    void doMovement() {
        int i;
        Vector<Case> bonnesPos = new Vector<Case>();
        int largeurRecherche = 1;
        int tX = (int)((double)this.largeurMap * this.getX() / this.getBattleFieldWidth());
        int tY = (int)((double)this.hauteurMap * this.getY() / this.getBattleFieldHeight());
        double min = 1000.0;
        int i2 = -largeurRecherche;
        while (i2 < largeurRecherche + 1) {
            int j = -largeurRecherche;
            while (j < largeurRecherche + 1) {
                if (i2 + tX >= 0 && i2 + tX < this.largeurMap && j + tY >= 0 && j + tY < this.hauteurMap) {
                    bonnesPos.add(new Case(i2 + tX, j + tY, this.map[i2 + tX][j + tY]));
                    if (this.map[i2 + tX][j + tY] < min) {
                        min = this.map[i2 + tX][j + tY];
                    }
                }
                ++j;
            }
            ++i2;
        }
        int nbElts = bonnesPos.size();
        double min2 = 1000.0;
        int k = 0;
        while (k < nbElts) {
            Case tmpCase = (Case)bonnesPos.elementAt(k);
            if (tmpCase.getCoef() == min) {
                tmpCase.setCoef(0.0);
                int nbCases = 0;
                i = -1;
                while (i < 2) {
                    int j = -1;
                    while (j < 2) {
                        if (i + tmpCase.getX() >= 0 && i + tmpCase.getX() < this.largeurMap && j + tmpCase.getY() >= 0 && j + tmpCase.getY() < this.hauteurMap) {
                            ++nbCases;
                            tmpCase.setCoef(tmpCase.getCoef() + this.map[i + tmpCase.getX()][j + tmpCase.getY()]);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (tmpCase.getCoef() < min2) {
                    min2 = tmpCase.getCoef();
                }
                tmpCase.setCoef(tmpCase.getCoef() / (double)nbCases);
            } else {
                bonnesPos.remove(k);
                --k;
                --nbElts;
            }
            ++k;
        }
        min = 1000.0;
        Case destination = new Case(5, 5);
        i = 0;
        while (i < bonnesPos.size()) {
            Case tmpCase = (Case)bonnesPos.elementAt(i);
            if (tmpCase.getCoef() < min) {
                min = tmpCase.getCoef();
                destination = tmpCase;
            }
            ++i;
        }
        if (destination.getX() == (int)((double)this.hauteurMap * this.getX() / this.getBattleFieldHeight()) && destination.getY() == (int)((double)this.hauteurMap * this.getY() / this.getBattleFieldHeight())) {
            double angle = Utils.normalRelativeAngle((double)(new Point2D(this.target.x, this.target.y).absbearing(new Point2D(this.getX(), this.getY())) + this.PI / (double)2 - this.getHeadingRadians()));
            if (Math.abs(angle) > this.PI / (double)2) {
                angle = angle > 0.0 ? (angle -= this.PI) : (angle += this.PI);
            }
            this.setTurnRightRadians(angle);
        } else {
            this.goTo(new Point2D(this.getBattleFieldWidth() * ((double)destination.getX() + 0.5) / (double)this.largeurMap, this.getBattleFieldHeight() * ((double)destination.getY() + 0.5) / (double)this.hauteurMap));
        }
    }

    void doFirePower() {
        this.firePower = this.getEnergy() > 0.1 ? (double)5 / this.target.distance * this.max(this.getEnergy() + 50.0, 100.0) : 0.0;
    }

    double max(double nb, double max) {
        if (nb > max) {
            return max;
        }
        return nb;
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.target.ctime > (long)4 ? 360.0 : ((radarOffset = this.angle(this.getRadarHeadingRadians(), this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y))) < 0.0 ? (radarOffset -= this.PI / 16.0) : (radarOffset += this.PI / 16.0));
        this.setTurnRadarLeftRadians(this.NormaliseBearing(radarOffset));
    }

    double angle(double a1, double a2) {
        double dist = a1 - a2;
        if (dist > this.PI) {
            dist -= (double)2 * this.PI;
        }
        if (dist < -this.PI) {
            dist += (double)2 * this.PI;
        }
        return dist;
    }

    void doGun() {
        switch (this.method) {
            case 1: {
                long time = this.getTime() + (long)((int)(this.target.distance / (20.0 - (double)3 * this.firePower)));
                double gunOffset = this.angle(this.getGunHeadingRadians(), this.absbearing(this.getX(), this.getY(), this.target.guessX(time), this.target.guessY(time)));
                this.setTurnGunLeftRadians(this.NormaliseBearing(gunOffset));
                break;
            }
            case 0: {
                int distanceIndex = (int)Math.round(Math.sqrt(this.target.distance / 40.0));
                this.setTurnGunRightRadians(Math.sin(this.target.bearing + this.getHeadingRadians() - this.getGunHeadingRadians() + this.target.direction / Math.abs(this.target.direction) * (((double)this.bestAngularOffset - 13.0) / 26.0 * (double)3 / (double)4)));
            }
        }
    }

    double NormaliseBearing(double ang) {
        if (ang > this.PI) {
            ang -= (double)2 * this.PI;
        }
        if (ang < -this.PI) {
            ang += (double)2 * this.PI;
        }
        return ang;
    }

    double NormaliseHeading(double ang) {
        if (ang > (double)2 * this.PI) {
            ang -= (double)2 * this.PI;
        }
        if (ang < 0.0) {
            ang += (double)2 * this.PI;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getrange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    void setCoef(int pX, int pY, double pCoef) {
        this.setCoef(pX, pY, pCoef, -1);
    }

    void setCoef(int pX, int pY, double pCoef, int pFracMap) {
        int fracMap = 6;
        if (pFracMap > 0) {
            fracMap = pFracMap;
        }
        Point2D ptOrig = new Point2D(0.0, 0.0);
        double distMax = ptOrig.distance(new Point2D(this.getBattleFieldHeight() / (double)fracMap / (this.getBattleFieldHeight() / (double)this.hauteurMap), this.getBattleFieldWidth() / (double)fracMap / (this.getBattleFieldWidth() / (double)this.largeurMap)));
        ptOrig = new Point2D(pX, pY);
        int i = (int)(-distMax);
        while (i < (int)distMax + 1) {
            int j = (int)(-distMax);
            while (j < (int)distMax + 1) {
                if (i + pX >= 0 && i + pX < this.largeurMap && j + pY >= 0 && j + pY < this.hauteurMap) {
                    double coef = distMax - ptOrig.distance(new Point2D(pX + i, pY + j));
                    if (coef < 0.0) {
                        coef = 0.0;
                    }
                    double[] dArray = this.map[pX + i];
                    int n = pY + j;
                    dArray[n] = dArray[n] + (coef /= distMax) * pCoef;
                }
                ++j;
            }
            ++i;
        }
    }

    public void onPaint(Graphics2D g) {
        int i = 0;
        while (i < this.balles.size()) {
            BulletV4 tmpBullet = (BulletV4)this.balles.elementAt(i);
            switch (tmpBullet.method) {
                case 0: {
                    g.setColor(new Color(Color.HSBtoRGB((float)(0.7 - Math.min(0.7, 2.5 * data[tmpBullet.distanceIndex][i])), 1.0f, 1.0f)));
                    break;
                }
                case 1: {
                    g.setColor(Color.green);
                    break;
                }
                case 2: {
                    g.setColor(Color.red);
                }
            }
            g.fillOval((int)(tmpBullet.x - (double)2), (int)(600.0 - tmpBullet.y - (double)2), 4, 4);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.largeurMap = 16;
        this.hauteurMap = 12;
        this.mode = 1;
        this.method = 0;
        this.PI = Math.PI;
        this.balles = new Vector();
        this.vagues = new Vector();
        this.map = new double[this.largeurMap][this.hauteurMap];
        this.bestAngularOffset = 0;
    }

    public OoV4() {
        this.this();
    }
}

