/*
 * Decompiled with CFR 0.152.
 */
package dittman;

import dittman.Enemy;
import dittman.ScanData;
import java.awt.Color;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;

public class BlindSquirl
extends AdvancedRobot {
    Enemy target;
    final double PI = Math.PI;
    final double GUN_ROTATION_RATE = 0.3490658503988659;
    final double MAX_POWER = 3.0;
    final int REFRESH = 15;
    final double SCANNER_CONE = 0.04908738521234052;
    final int ACCEPTABLE_MISSES = 3;
    final double MIN_POWER = 1.0;
    final double MIN_DISTANCE_TARGET = 150.0;
    boolean ok_to_fire;
    double power;
    final double WALL_BUFFER = 25.0;
    final double WALL_TURN_VELOCITY = 4.0;
    final double MAX_SPEED = 8.0;
    final double V_MODIFIER = 1.0;
    int direction = 1;
    long bullet_dodge_delay = 0L;
    boolean hitWall = false;
    boolean hitRobot = false;

    public void run() {
        this.target = new Enemy();
        this.setColors(Color.red, Color.blue, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.doMovement();
            this.doScanner();
            this.doGun();
            this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
            this.shoot();
            this.execute();
        }
    }

    void shoot() {
        Bullet b = null;
        if (this.getTime() - this.target.getTime() < 15L && this.ok_to_fire && (b = this.setFireBullet(this.power)) != null) {
            this.out.println("Power: " + b.getPower());
        }
    }

    public void onHitWall(HitWallEvent event) {
        this.hitWall = true;
    }

    public void onBulletHit(BulletHitEvent event) {
        if (event.getName() == this.target.getName()) {
            this.target.initMissCount();
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.target.incrementMissCount();
    }

    void doMovement() {
        Random r = new Random(System.currentTimeMillis());
        int distance = 16;
        if (this.hitWall) {
            this.out.println("Hit Wall!");
            this.direction *= -1;
            this.setAhead(this.direction * distance / 2);
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
        } else if (this.goingToHitWall(this.getHeadingRadians())) {
            this.out.println("Avoid wall!");
            this.setMaxVelocity(4.0);
            this.direction = -1;
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        } else if (this.target.getDistance() < 150.0) {
            this.out.println("Run away. Run away! direction: " + this.direction);
            this.direction = -1;
            this.setTurnRightRadians((double)this.direction * this.normalizeBearing(this.absbearing(this.getX(), this.getY(), this.target.getX(), this.target.getY() - this.getHeadingRadians())));
            this.setMaxVelocity(8.0);
        } else {
            this.out.println("Stand and fight!");
            this.setTurnRightRadians(this.target.getBearing() + 1.5707963267948966);
            this.setMaxVelocity(r.nextInt(2) + 6);
            if (this.target.getEnergy() < this.target.getEnergy(1)) {
                this.direction = -1;
            }
        }
        this.setAhead(this.direction * distance);
        this.hitRobot = false;
        this.hitWall = false;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.hitRobot = true;
    }

    boolean goingToHitWall(double heading) {
        double x = this.getX() + Math.sin(heading) * (25.0 * this.getVelocity());
        double y = this.getY() + Math.cos(heading) * (25.0 * this.getVelocity());
        return this.getBattleFieldHeight() - 25.0 - 1.0 < y || this.getBattleFieldWidth() - 25.0 - 1.0 < x || x < 25.0 || y < 25.0;
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.target.getTime() > 4L || this.getTime() % 15L == 0L ? 360.0 : ((radarOffset = this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.getX(), this.target.getY())) < 0.0 ? (radarOffset -= 0.04908738521234052) : (radarOffset += 0.04908738521234052));
        this.setTurnRadarLeftRadians(this.normalizeBearing(radarOffset));
    }

    void doGun() {
        double gunOffset = 0.0;
        double time = 0.0;
        if (this.target.getScanCount() == 3) {
            ScanData th3;
            ScanData th1 = this.target.getScan(2);
            ScanData th2 = this.target.getScan(1);
            ScanData pred_target_loc = th3 = this.target.getScan(0);
            this.power = 0.0;
            while (this.power < 1.0) {
                pred_target_loc = this.predictTargetLoc(th1, th2, th3);
                this.power = pred_target_loc.distance < 150.0 ? 3.0 : (20.0 - pred_target_loc.distance / (time += 1.0)) / 3.0;
                th1 = th2;
                th2 = th3;
                th3 = pred_target_loc;
                if (!(this.power > 3.0)) continue;
                this.power = 3.0;
            }
            gunOffset = this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), pred_target_loc.x, pred_target_loc.y);
        } else {
            gunOffset = this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.getX(), this.target.getY());
        }
        this.ok_to_fire = gunOffset / 0.3490658503988659 <= 1.0;
        this.setTurnGunLeftRadians(this.normalizeBearing(gunOffset));
    }

    long getBulletTimeToTarget(double distance) {
        return this.getTime() + (long)((int)(distance / (20.0 - 3.0 * this.power)));
    }

    ScanData predictTargetLoc(ScanData th1, ScanData th2, ScanData th3) {
        ScanData pred_target = new ScanData();
        double h1 = this.absbearing(th1.x, th1.y, th2.x, th2.y);
        double h2 = this.absbearing(th2.x, th2.y, th3.x, th3.y);
        pred_target.head = h2 + (h2 - h1);
        pred_target.speed = th3.speed + (th3.speed - th2.speed);
        if (pred_target.speed > 8.0) {
            pred_target.speed = 8.0;
        } else if (pred_target.speed < 0.0) {
            pred_target.speed = 0.0;
        }
        pred_target.x = th3.x + Math.sin(pred_target.head) * (pred_target.speed * 1.0);
        pred_target.y = th3.y + Math.cos(pred_target.head) * (pred_target.speed * 1.0);
        pred_target.distance = this.getrange(this.getX(), this.getY(), pred_target.x, pred_target.y);
        return pred_target;
    }

    double normalizeBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normalizeHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getrange(x1, y1, x2, y2);
        if (xo == 0.0 && yo > 0.0) {
            return 0.0;
        }
        if (xo == 0.0 && yo < 0.0) {
            return Math.PI;
        }
        if (xo < 0.0 && yo == 0.0) {
            return 4.71238898038469;
        }
        if (xo > 0.0 && yo == 0.0) {
            return 1.5707963267948966;
        }
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.target.getNeedTarget() || e.getDistance() < this.target.getDistance() || this.target.getName() == e.getName()) {
            if (this.target.getName() != e.getName()) {
                this.target.clear();
            }
            double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            ScanData sd = new ScanData();
            this.target.setName(e.getName());
            sd.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
            sd.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
            sd.bearing = e.getBearingRadians();
            sd.head = e.getHeadingRadians();
            sd.time = this.getTime();
            sd.speed = e.getVelocity();
            sd.distance = e.getDistance();
            sd.energy = e.getEnergy();
            this.target.addScan(sd);
            this.target.setNeedTarget(false);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.getName()) {
            this.target.setNeedTarget(true);
        }
    }
}

