/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import jcs.Coord;
import jcs.Enemy;
import jcs.Seth;
import jcs.TargetingMode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AntiGravTargeting
extends TargetingMode {
    private double xWall;
    private double yWall;
    private double WALL_TOLERANCE;

    public double calcBulletPower(Enemy target) {
        double distance = this.seth.getCurrentPos().calcDist(target.getCoord());
        double power = 3;
        if (distance < 300.0) {
            power = 3;
        } else {
            double temp = distance - 300.0 + 1.0;
            power = 900.0 * (target.getRatio(0) / distance);
        }
        if (this.seth.getEnergy() < 9.1 && power > this.seth.getEnergy()) {
            power = this.seth.getEnergy() / (double)3;
        }
        if (power * (double)4 > target.getEnergy()) {
            power = target.getEnergy() / (double)4;
        }
        return power;
    }

    public double calcPoint(Enemy target, double time) {
        Enemy[] enemies = this.seth.getEnemyList().getEnemies();
        double botX = 0.0;
        double botY = 0.0;
        double xSum = 0.0;
        double ySum = 0.0;
        double distance = time * target.getVelocity();
        Coord walls = this.wallSum(target.getCoord());
        int i = 0;
        while (i < enemies.length && enemies[i] != null) {
            Coord temp = enemies[i] == target ? this.pointSum(target.getCoord(), this.seth.getCurrentPos(), 1.0) : this.pointSum(target.getCoord(), enemies[i].getCoord(), 1.0);
            botX += temp.getX();
            botY += temp.getY();
            ++i;
        }
        xSum = botX / (double)(this.seth.getEnemyList().getCount() + 1) + walls.getX();
        ySum = botY / (double)(this.seth.getEnemyList().getCount() + 1) + walls.getY();
        Coord enemyVector = target.getCoord().getCoordFromScan(target.getBearing(), distance / (double)2);
        Coord AGFire = new Coord(xSum + enemyVector.getX(), ySum + enemyVector.getY());
        System.out.println("firing by antigrav at : " + AGFire.toString());
        return this.seth.getCurrentPos().calcHeading(AGFire);
    }

    private final Coord wallSum(Coord currentPos) {
        double sumX = 0.0;
        double sumY = 0.0;
        if (currentPos.getX() < this.WALL_TOLERANCE) {
            sumX += 1000.0 * (1.0 / currentPos.getX());
        }
        if (currentPos.getY() < this.WALL_TOLERANCE) {
            sumY += 1000.0 * (1.0 / currentPos.getY());
        }
        if (this.xWall - currentPos.getX() < this.WALL_TOLERANCE) {
            sumX -= 1000.0 * (1.0 / (this.xWall - currentPos.getX()));
        }
        if (this.yWall - currentPos.getY() < this.WALL_TOLERANCE) {
            sumY -= 1000.0 * (1.0 / (this.yWall - currentPos.getY()));
        }
        return new Coord(sumX, sumY);
    }

    private final Coord pointSum(Coord currentPos, Coord enemyPos, double power) {
        double distance = currentPos.calcDist(enemyPos);
        double theta = enemyPos.calcHeading(currentPos);
        double force = power * 12000.0 * (1.0 / distance);
        Coord sum = currentPos.getCoordFromScan(theta, force);
        sum.setX(sum.getX() - currentPos.getX());
        sum.setY(sum.getY() - currentPos.getY());
        return sum;
    }

    private final /* synthetic */ void this() {
        this.WALL_TOLERANCE = 100.0;
    }

    public AntiGravTargeting(Seth _seth) {
        this.this();
        this.seth = _seth;
        this.xWall = _seth.getBattleFieldWidth();
        this.yWall = _seth.getBattleFieldHeight();
    }
}

