/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.waves;

import ags.rougedc.robots.VirtualRobot;
import ags.util.Range;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.ArrayList;
import java.util.List;
import robocode.Rules;
import robocode.util.Utils;

public abstract class Wave
implements Cloneable {
    private final AbsolutePoint origin;
    private final double power;
    private final double speed;
    private double radius;
    private Range hitrange;
    private Range newhitrange;
    private Range lasthitrange;
    public final AbsolutePoint staticl;
    public final RelativePoint staticr;
    public final double origDist;

    public Wave(AbsolutePoint origin, double power, double radius, AbsolutePoint l, RelativePoint v) {
        this.origin = (AbsolutePoint)origin.clone();
        this.power = power;
        this.speed = Rules.getBulletSpeed((double)power);
        this.radius = radius;
        this.staticl = l;
        this.staticr = v;
        this.origDist = origin.distance(l);
    }

    protected Wave(Wave source) {
        this.origin = source.origin;
        this.power = source.power;
        this.speed = source.speed;
        this.radius = source.radius;
        this.staticl = source.staticl;
        this.staticr = source.staticr;
        this.origDist = source.origDist;
        if (source.hitrange != null) {
            this.hitrange = source.hitrange.clone();
        }
        if (source.newhitrange != null) {
            this.newhitrange = source.newhitrange.clone();
        }
        if (source.lasthitrange != null) {
            this.lasthitrange = source.lasthitrange.clone();
        }
    }

    public AbsolutePoint getOrigin() {
        return this.origin;
    }

    public double getPower() {
        return this.power;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getOrigDist() {
        return this.origDist;
    }

    public void move() {
        this.radius += this.speed;
    }

    public void checkHit(VirtualRobot r) {
        this.lasthitrange = this.hitrange;
        this.newhitrange = this.getGuessRange(r.getLocation());
        if (this.hitrange == null) {
            this.hitrange = this.newhitrange;
        } else if (this.newhitrange != null) {
            this.hitrange = this.hitrange.grow(this.newhitrange);
        }
    }

    public Range getHitRange() {
        return this.hitrange;
    }

    public Range getNewHitRange() {
        return this.newhitrange;
    }

    public Range getLastHitRange() {
        return this.lasthitrange;
    }

    public boolean expired(VirtualRobot r) {
        return this.origin.distance(r.getLocation()) + Math.sqrt(648.0) < this.radius - this.speed;
    }

    public boolean isNear(AbsolutePoint p, double margin) {
        double d = this.origin.distance(p);
        return d <= this.radius + margin && d >= this.radius - margin;
    }

    public boolean isNearOld(AbsolutePoint p, double margin) {
        double d = this.origin.distance(p);
        return d <= this.radius - this.speed + margin && d >= this.radius - this.speed - margin;
    }

    public boolean intersects(AbsolutePoint p) {
        double d = this.origin.distance(p);
        return d <= this.radius && d >= this.radius - this.speed;
    }

    public boolean intersects(RelativePoint p) {
        return p.magnitude <= this.radius && p.magnitude >= this.radius - this.speed;
    }

    public double getMaxEscapeAngle() {
        return Math.asin(8.0 / this.speed);
    }

    public double getAngleTo(AbsolutePoint p) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(p.x - this.origin.x, p.y - this.origin.y));
    }

    public double getHOTAngle() {
        AbsolutePoint p = this.staticl;
        return Utils.normalAbsoluteAngle((double)Math.atan2(p.x - this.origin.x, p.y - this.origin.y));
    }

    private double getTargetLateralDirection() {
        RelativePoint v = this.staticr;
        double lateralVelocity = v.magnitude * Math.sin(v.getDirection() - this.getHOTAngle());
        if (lateralVelocity >= 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public double getGuessFactor(double angle) {
        return this.getTargetLateralDirection() * Utils.normalRelativeAngle((double)(angle - this.getHOTAngle())) / this.getMaxEscapeAngle();
    }

    public double getGuessFactor(RelativePoint p) {
        return this.getGuessFactor(p.getDirection());
    }

    public double getGuessFactor(AbsolutePoint p) {
        return this.getGuessFactor(RelativePoint.fromPP(this.origin, p));
    }

    public double getAngle(double guessfactor) {
        return Utils.normalAbsoluteAngle((double)(guessfactor * this.getMaxEscapeAngle() / this.getTargetLateralDirection() + this.getHOTAngle()));
    }

    public Range getGuessRange(AbsolutePoint p) {
        if (Math.abs(this.origin.distance(p) - this.radius) > Math.sqrt(648.0) + this.speed) {
            return null;
        }
        ArrayList<AbsolutePoint> possiblepoints = new ArrayList<AbsolutePoint>();
        double bottom = p.y - 18.0;
        double top = p.y + 18.0;
        double left = p.x - 18.0;
        double right = p.x + 18.0;
        double lastradius = this.radius - this.speed;
        possiblepoints.addAll(Wave.XCircleIntersect(this.origin, lastradius, left, bottom, top));
        possiblepoints.addAll(Wave.XCircleIntersect(this.origin, this.radius, left, bottom, top));
        possiblepoints.addAll(Wave.XCircleIntersect(this.origin, lastradius, right, bottom, top));
        possiblepoints.addAll(Wave.XCircleIntersect(this.origin, this.radius, right, bottom, top));
        possiblepoints.addAll(Wave.YCircleIntersect(this.origin, lastradius, bottom, left, right));
        possiblepoints.addAll(Wave.YCircleIntersect(this.origin, this.radius, bottom, left, right));
        possiblepoints.addAll(Wave.YCircleIntersect(this.origin, lastradius, top, left, right));
        possiblepoints.addAll(Wave.YCircleIntersect(this.origin, this.radius, top, left, right));
        AbsolutePoint c1 = AbsolutePoint.fromXY(left, bottom);
        AbsolutePoint c2 = AbsolutePoint.fromXY(left, top);
        AbsolutePoint c3 = AbsolutePoint.fromXY(right, top);
        AbsolutePoint c4 = AbsolutePoint.fromXY(right, bottom);
        if (this.intersects(c1)) {
            possiblepoints.add(c1);
        }
        if (this.intersects(c2)) {
            possiblepoints.add(c2);
        }
        if (this.intersects(c3)) {
            possiblepoints.add(c3);
        }
        if (this.intersects(c4)) {
            possiblepoints.add(c4);
        }
        Range r = null;
        for (AbsolutePoint point : possiblepoints) {
            double gf = this.getGuessFactor(point);
            r = r != null ? r.grow(gf) : new Range(gf);
        }
        return r;
    }

    private static List<AbsolutePoint> XCircleIntersect(AbsolutePoint origin, double r, double x, double miny, double maxy) {
        ArrayList<AbsolutePoint> intersects = new ArrayList<AbsolutePoint>();
        double dx = x - origin.x;
        double D = r * r - dx * dx;
        if (D < 0.0) {
            return intersects;
        }
        double d = Math.sqrt(D);
        double y1 = origin.y + d;
        if (y1 >= miny && y1 <= maxy) {
            intersects.add(AbsolutePoint.fromXY(x, y1));
        }
        if (D == 0.0) {
            return intersects;
        }
        double y2 = origin.y - d;
        if (y2 >= miny && y2 <= maxy) {
            intersects.add(AbsolutePoint.fromXY(x, y2));
        }
        return intersects;
    }

    private static List<AbsolutePoint> YCircleIntersect(AbsolutePoint origin, double r, double y, double minx, double maxx) {
        ArrayList<AbsolutePoint> intersects = new ArrayList<AbsolutePoint>();
        double dy = y - origin.y;
        double D = r * r - dy * dy;
        if (D < 0.0) {
            return intersects;
        }
        double d = Math.sqrt(D);
        double x1 = origin.x + d;
        if (x1 >= minx && x1 <= maxx) {
            intersects.add(AbsolutePoint.fromXY(x1, y));
        }
        if (D == 0.0) {
            return intersects;
        }
        double x2 = origin.x - d;
        if (x2 >= minx && x2 <= maxx) {
            intersects.add(AbsolutePoint.fromXY(x2, y));
        }
        return intersects;
    }
}

