/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class MeanVarStat
extends AbstractStat {
    private final String name;
    private float sum;
    private float sumsq;
    private float n;
    private float mean;
    private float var;

    public MeanVarStat(MeanVarStat that) {
        this.name = that.name;
        this.sum = that.sum;
        this.sumsq = that.sumsq;
        this.n = that.n;
        this.mean = that.mean;
        this.var = that.var;
    }

    public MeanVarStat(String name) {
        this.name = name;
    }

    public void add(float obs) {
        this.sum += obs;
        this.sumsq += obs * obs;
        this.n += 1.0f;
    }

    public void add(MeanVarStat that) {
        this.sum += that.sum;
        this.sumsq += that.sumsq;
        this.n += that.n;
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof MeanVarStat)) {
            throw new IllegalArgumentException("Can only add in other MeanVarStats.");
        }
        this.add((MeanVarStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        map.put(prefix + this.name + "Mean", Float.valueOf(this.mean));
        map.put(prefix + this.name + "Var", Float.valueOf(this.var));
    }

    @Override
    public void analyze() {
        this.mean = this.sum / this.n;
        this.var = (this.sumsq - 2.0f * this.sum * this.mean) / this.n + this.mean * this.mean;
    }

    @Override
    public void clear() {
        this.sum = 0.0f;
        this.sumsq = 0.0f;
        this.n = 0.0f;
        this.mean = 0.0f;
        this.var = 0.0f;
    }

    public float getMean() {
        return this.mean;
    }

    public float getVar() {
        return this.var;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.appendField(this.mean);
        out.appendField(this.var);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.appendHeader(prefix + this.name + "Mean");
        out.appendHeader(prefix + this.name + "Var");
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        String prename = prefix + this.name;
        sb.append(prename);
        sb.append("Mean = ");
        sb.append(this.mean);
        sb.append("\n");
        sb.append(prename);
        sb.append("Variance = ");
        sb.append(this.var);
        sb.append("\n");
        return sb.toString();
    }
}

