/*
 * Decompiled with CFR 0.152.
 */
package knackibot;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import knackibot.Enemy;
import knackibot.KnackOnOne;
import knackibot.MovementStrategy;
import knackibot.MyUtils;
import robocode.util.Utils;

public class RandomMovement
implements MovementStrategy {
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    KnackOnOne me;
    Enemy enemy;
    double movementLateralAngle = 0.2;

    public RandomMovement(KnackOnOne bot, Enemy enemy) {
        this.me = bot;
        this.enemy = enemy;
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.me.getBattleFieldWidth() - margin * 2.0, this.me.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    void goTo(Point2D.Double destination) {
        double angle = Utils.normalRelativeAngle((double)(MyUtils.calcAbsBearing(this.me.ownPos, destination) - this.me.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.me.setTurnRightRadians(turnAngle);
        this.me.setAhead(this.me.ownPos.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        this.me.setMaxVelocity(Math.abs(this.me.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
    }

    @Override
    public void move(Enemy enemy, KnackOnOne me) {
        this.considerChangingDirection();
        double localMovementLateralAngle = this.movementLateralAngle;
        Point2D.Double robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = MyUtils.calcPoint(enemy.getCurrentPosition(), enemy.getDistance() * (1.1 - tries % 100.0 / 100.0), MyUtils.calcAbsBearing(enemy.getCurrentPosition(), me.ownPos) + localMovementLateralAngle);
        } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(25.0).contains(robotDestination));
        this.goTo(robotDestination);
    }
}

