/*
 * Decompiled with CFR 0.152.
 */
package kid.data.pattern;

import kid.data.pattern.Pattern;
import kid.info.RobotInfo;
import kid.utils.Utils;

public class Polar
extends Pattern {
    private static final long serialVersionUID = 8849260510359616074L;
    public static final Polar DUMMY_PATTERN = new Polar(10.0, 8.0, 3.0);
    private double deltaHeading;
    private double velocity;
    private char symbol;

    public Polar(double deltaHeading, double velocity, double acceleration) {
        this.deltaHeading = deltaHeading;
        this.velocity = velocity;
        int charVel = Utils.round((velocity + 8.0) * 15.0 / 17.0);
        int charDHead = Utils.round((deltaHeading + RobotInfo.MAX_TURN_RATE) * 63.0 / (2.0 * RobotInfo.MAX_TURN_RATE + 1.0));
        int charAccel = 0;
        this.symbol = (char)(charAccel << 12 | charVel << 7 | charDHead);
    }

    public double getDeltaHeading() {
        return this.deltaHeading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public char getFold() {
        return this.symbol;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Polar) {
            Polar p = (Polar)obj;
            return this.symbol == p.symbol;
        }
        return false;
    }
}

