/*
 * Decompiled with CFR 0.152.
 */
package simonton.movements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import simonton.core.Bot;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.GFProbability;

public class Destination
extends Location {
    public GFProbability safety;
    public long deadline;
    public long arrivalTime;
    public double arrivalAngle;
    public double arrivalSpeed;
    public double distFromWave;
    public boolean totallyImpossible;

    public Destination(Bot bot) {
        this(new Location(bot), bot.getTime(), bot.getTime(), bot.getHeadingRadians(), bot.getVelocity(), null, 0.0);
    }

    public Destination(Location location, long deadline, long arrivalTime, double arrivalAngle, double arrivalSpeed, GFProbability safety, double distFromWave) {
        super(location);
        this.deadline = deadline;
        this.arrivalTime = arrivalTime;
        this.arrivalAngle = arrivalAngle;
        this.arrivalSpeed = arrivalSpeed;
        this.safety = safety;
        this.distFromWave = distFromWave;
    }

    public void onPaint(Graphics2D g, long time) {
        int r = (int)((this.deadline - time) / 2L);
        int lowX = (int)(this.x - (double)r);
        int lowY = (int)(this.y - (double)r);
        int highX = (int)(this.x + (double)r);
        int highY = (int)(this.y + (double)r);
        g.drawLine(lowX, (int)this.y, highX, (int)this.y);
        g.drawLine((int)this.x, lowY, (int)this.x, highY);
        g.drawOval(lowX, lowY, 2 * r, 2 * r);
        g.drawString(String.format("%.2f", this.arrivalSpeed), (float)this.getX() - 45.0f, (float)this.getY() + 12.0f);
        g.drawString("" + this.arrivalTime, (float)this.getX() - 45.0f, (float)this.getY() + 0.0f);
        g.drawString("" + this.deadline, (float)this.getX() - 45.0f, (float)this.getY() - 12.0f);
        g.setColor(Color.PINK);
        Util.paintLine(g, (Point2D.Double)this, Util.project((Point2D.Double)this, 30.0, this.arrivalAngle));
    }

    @Override
    public String toString() {
        return String.format("%s @ %d", super.toString(), this.deadline);
    }
}

