/*
 * Decompiled with CFR 0.152.
 */
package rjw;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import rjw.AbstractComponent;
import rjw.Memory;
import rjw.Props;
import rjw.RabidWombat;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.Hud;
import rjw.pluggablerobot.Math2;
import rjw.radar.Enemy;
import rjw.radar.EnemyScan;
import rjw.radar.EnemyWave;
import rjw.util.Particle;
import rjw.util.Vector;
import robocode.util.Utils;

public class SpringMovement
extends AbstractComponent
implements Hud.Painter {
    private final double BASE_DISTANCE;
    private final double ENERGY_RANGE;
    private final double SPRING_CONSTANT;
    private final double MIN_FORCE;
    private final double MAX_FORCE;
    private final int IGNORE_SPRING_TIME;
    private final double WALL_FORCE_CONSTANT;
    private final double MAX_WALL_FORCE_DISTANCE;
    private final double MAX_BULLET_DODGE_DISTANCE;
    private final double MIN_BRAKING_ANGLE;
    private final double MAX_SHARP_TURN_VELOCITY;
    private int ignoreSpringTicks = 0;

    public SpringMovement(RabidWombat bot) {
        super(bot);
        Props p = RabidWombat.getProps();
        this.BASE_DISTANCE = p.getDouble("spring.baseDistance", 250.0);
        this.ENERGY_RANGE = p.getDouble("spring.energyRange", 50.0);
        this.SPRING_CONSTANT = p.getDouble("spring.constant", 0.5);
        this.MIN_FORCE = p.getDouble("spring.minForce", 10.0);
        this.MAX_FORCE = p.getDouble("spring.maxForce", 50.0);
        this.IGNORE_SPRING_TIME = p.getInt("spring.ignoreTime", 25);
        this.WALL_FORCE_CONSTANT = p.getDouble("wall.constant", 100.0);
        this.MAX_WALL_FORCE_DISTANCE = p.getDouble("wall.maxDistance", 100.0);
        this.MAX_BULLET_DODGE_DISTANCE = p.getDouble("dodge.maxDistance", 150.0);
        this.MIN_BRAKING_ANGLE = p.getDouble("brake.minAnglePiFactor", 0.25) * Math.PI;
        this.MAX_SHARP_TURN_VELOCITY = p.getDouble("brake.maxSharpTurnVelocity", 4.0);
    }

    @Override
    public void go() {
        Vector dodgeForce;
        Vector wallForce;
        Vector springForce = this.ignoreSpringTicks == 0 ? this.hookesLaw() : null;
        Vector sumForce = Vector.add(springForce, wallForce = this.wallForce(), dodgeForce = this.bulletDodgeForce());
        if ((sumForce == null || sumForce.d < this.MIN_FORCE) && springForce != null && this.ignoreSpringTicks == 0) {
            sumForce = Vector.add(wallForce, dodgeForce);
            this.ignoreSpringTicks = this.IGNORE_SPRING_TIME;
        }
        if (sumForce == null || sumForce.d < this.MIN_FORCE) {
            Enemy target = this.getMemory().getTarget();
            if (target == null) {
                return;
            }
            double bearing = this.getBot().getParticle().getAbsoluteTargetBearing(target.get(0));
            double course = Utils.normalAbsoluteAngle((double)(bearing + 1.5707963267948966));
            sumForce = new Vector(course, 0.0);
        }
        double currentHeading = this.getBot().getHeadingRadians();
        double deltaTheta = Utils.normalRelativeAngle((double)(sumForce.t - currentHeading));
        double absDeltaTheta = Math.abs(deltaTheta);
        double direction = 1.0;
        if (absDeltaTheta > 1.5707963267948966) {
            deltaTheta = (double)(deltaTheta < 0.0 ? 1 : -1) * (Math.PI - absDeltaTheta);
            direction = -1.0;
        }
        double minVelocity = deltaTheta > this.MIN_BRAKING_ANGLE ? this.MAX_SHARP_TURN_VELOCITY : 0.0;
        double velocity = Math.abs(sumForce.d / this.MAX_FORCE * 8.0);
        velocity = Math2.limit(minVelocity, velocity, 8.0);
        this.getBot().setTurnRightRadians(deltaTheta);
        this.getBot().setMaxVelocity(velocity);
        this.getBot().setAhead(direction * 1000.0);
        if (this.ignoreSpringTicks > 0) {
            --this.ignoreSpringTicks;
        }
    }

    private Vector hookesLaw() {
        if (this.getMemory().getTarget() == null) {
            return null;
        }
        Particle me = this.getBot().getParticle();
        EnemyScan enemy = this.getMemory().getTarget().get(0);
        double distance = me.getDistance(enemy);
        double angle = me.getAbsoluteTargetBearing(enemy);
        double force = this.SPRING_CONSTANT * (distance - this.desiredDistance());
        return Math.abs(force) >= this.MIN_FORCE ? new Vector(angle, force) : null;
    }

    private Vector wallForce() {
        if (this.isEnemyDisabled()) {
            return null;
        }
        Point2D.Double pos = this.getBot().getPosition();
        double fx = this.calculateWallForce(this.getBot().getBattleFieldWidth(), pos.x, this.getBot().getWidth());
        double fy = this.calculateWallForce(this.getBot().getBattleFieldHeight(), pos.y, this.getBot().getHeight());
        double t = Math.atan2(fx, fy);
        double f = Math.sqrt(Math.pow(fx, 2.0) + Math.pow(fy, 2.0));
        return f >= this.MIN_FORCE ? new Vector(t, f) : null;
    }

    private Vector bulletDodgeForce() {
        double guessedFireAngle;
        RabidWombat bot = this.getBot();
        List<EnemyWave> waves = bot.getMemory().getWaves();
        if (waves.isEmpty()) {
            return null;
        }
        EnemyWave wave = waves.get(0);
        double distance = wave.distance(bot.getPosition(), bot.getTime());
        if (distance > this.MAX_BULLET_DODGE_DISTANCE) {
            return null;
        }
        double currentBearing = Math2.getAbsoluteTargetBearing(wave.getOrigin(), bot.getPosition());
        double angleDiff = Utils.normalRelativeAngle((double)(currentBearing - (guessedFireAngle = wave.getTargetBearing())));
        int direction = angleDiff < 0.0 ? -1 : 1;
        double escapeAngle = currentBearing + (double)direction * 1.5707963267948966;
        return new Vector(escapeAngle, this.MAX_FORCE);
    }

    private boolean isEnemyDisabled() {
        Enemy target = this.getMemory().getTarget();
        if (target == null) {
            return false;
        }
        return target.get(0).getEnergy() == 0.0;
    }

    private double calculateWallForce(double length, double location, double girth) {
        int sign = location > length / 2.0 ? -1 : 1;
        double distance = (sign == 1 ? location : length - location) - girth / 2.0 + 1.0;
        if (distance >= this.MAX_WALL_FORCE_DISTANCE) {
            return 0.0;
        }
        double k = 1.5707963267948966 / this.MAX_WALL_FORCE_DISTANCE;
        return (double)sign * this.WALL_FORCE_CONSTANT * Math.cos(distance * k);
    }

    private double desiredDistance() {
        EnemyScan target = this.getMemory().getTarget().get(0);
        if (target.getEnergy() < 0.1) {
            return 0.0;
        }
        double diff = target.getEnergy() - this.getBot().getEnergy();
        if (Math.abs(diff) > this.ENERGY_RANGE) {
            diff = Math.signum(diff) * this.ENERGY_RANGE;
        }
        return this.BASE_DISTANCE + this.BASE_DISTANCE * diff / this.ENERGY_RANGE;
    }

    @Override
    public void paint(Canvas canvas, long tick) {
        Vector dodgeForce;
        Point2D.Double pos = this.getBot().getPosition();
        if (this.getBot().getOthers() > 0) {
            EnemyScan target;
            Enemy enemy = this.getMemory().getTarget();
            EnemyScan enemyScan = target = enemy != null ? enemy.get(0) : null;
            if (target != null) {
                canvas.setPaint(Color.MAGENTA);
                canvas.drawCircle(target.p().x, target.p().y, this.desiredDistance());
                Vector hookesLaw = this.hookesLaw();
                if (hookesLaw != null) {
                    SpringMovement.drawArrow(canvas, pos.x, pos.y, hookesLaw.t, hookesLaw.d);
                }
            }
        }
        canvas.setPaint(Color.BLUE);
        double forceBoxX = this.MAX_WALL_FORCE_DISTANCE + this.getBot().getWidth() / 2.0;
        double forceBoxY = this.MAX_WALL_FORCE_DISTANCE + this.getBot().getHeight() / 2.0;
        double forceBoxW = this.getBot().getBattleFieldWidth() - this.MAX_WALL_FORCE_DISTANCE * 2.0 - this.getBot().getWidth();
        double forceBoxH = this.getBot().getBattleFieldHeight() - this.MAX_WALL_FORCE_DISTANCE * 2.0 - this.getBot().getHeight();
        canvas.drawRect(forceBoxX, forceBoxY, forceBoxW, forceBoxH);
        Vector wallForce = this.wallForce();
        if (wallForce != null && wallForce.d > 0.0) {
            SpringMovement.drawArrow(canvas, pos.x, pos.y, wallForce.t, wallForce.d);
        }
        if ((dodgeForce = this.bulletDodgeForce()) != null) {
            canvas.setPaint(Color.RED);
            SpringMovement.drawArrow(canvas, pos.x, pos.y, dodgeForce.t, dodgeForce.d);
        }
    }

    private static void drawArrow(Canvas canvas, double x, double y, double t, double d) {
        double ax = d * Math.sin(t) + x;
        double ay = d * Math.cos(t) + y;
        canvas.drawLine(x, y, ax, ay);
        canvas.drawCircle(ax, ay, 3.0);
    }

    private Memory getMemory() {
        return this.getBot().getMemory();
    }
}

