/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pa3k.Aiming;
import pa3k.BulletTracking;
import pa3k.Cluster;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.Opponent;
import pa3k.Position;
import robocode.AdvancedRobot;
import robocode.Rules;

public class MonteCarloAiming
extends Aiming {
    protected MonteCarlo monteCarlo;

    public MonteCarloAiming(AdvancedRobot robot, String opponentName, boolean outging, MonteCarlo mc) {
        super(robot, opponentName, outging);
        this.monteCarlo = mc;
    }

    public static double getRandomHitProbability(MonteCarlo mc, double bulletSpeed, Position my) {
        double prob;
        Position[] p = mc.simulatePosition(bulletSpeed, my);
        List<Cluster> clusters = MonteCarloAiming.getClusters(p);
        if (clusters.size() == 0) {
            return 0.0;
        }
        Iterator<Cluster> it = clusters.iterator();
        Cluster m = null;
        while (it.hasNext()) {
            Cluster c = it.next();
            if (m != null && m.getWeight() >= c.getWeight()) continue;
            m = c;
        }
        double max = 1.0;
        long t = mc.getSamples();
        if (t < 150L) {
            max = 0.1;
        }
        if (t < 80L) {
            max = 0.05;
        }
        if (t < 30L) {
            max = 0.0;
        }
        return (prob = (double)m.getWeight() / (double)p.length) > max ? max : prob;
    }

    public static List<Cluster> getClusters(Position[] positions) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(5);
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p = positionArray[n2];
            Log.paintFilledCircle(3, p, 9, new Color(0, 255, 0, 5), 0);
            boolean fits = false;
            for (Cluster c : clusters) {
                if (!c.fits(p)) continue;
                fits = true;
                break;
            }
            if (!fits) {
                clusters.add(new Cluster(p));
            }
            ++n2;
        }
        return clusters;
    }

    @Override
    public BulletTracking getBestAimingAngle(Position source, Opponent target, double energy, long currentTime) {
        BulletTracking bt = new BulletTracking(energy, source, target, currentTime);
        Position[] positions = this.monteCarlo.simulatePosition(Rules.getBulletSpeed((double)energy), source);
        List<Cluster> clusters = MonteCarloAiming.getClusters(positions);
        Cluster largest = clusters.get(0);
        for (Cluster c : clusters) {
            if (c.getWeight() <= largest.getWeight()) continue;
            largest = c;
        }
        bt.setFiringAngle(source.getDirectionTo(largest.getPosition()));
        Log.paintFilledCircle(3, largest.getPosition(), 9, new Color(0, 0, 255, 80), 4);
        return bt;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bt) {
        double[] d = new double[1];
        return d;
    }
}

