/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.gfws.segment;

import xander.core.Resources;
import xander.core.log.Logger;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.segment.AbstractSegmenter;

public class DefenderAccelerationAndSpeedSegmenter
extends AbstractSegmenter {
    private SnapshotHistory snapshotHistory = Resources.getSnapshotHistory();

    public DefenderAccelerationAndSpeedSegmenter() {
        super(0.0, 18.0);
    }

    @Override
    public String getName() {
        return "Defender Accel and Speed Segmenter";
    }

    @Override
    public double getSegmentValue(Wave wave) {
        Snapshot snap = wave.getInitialDefenderSnapshot();
        Snapshot prevSnap = this.snapshotHistory.getPreviousSnapshot(snap);
        double segmentValue = 9.0;
        if (prevSnap != null) {
            double v1 = snap.getVelocity();
            double v0 = prevSnap.getVelocity();
            if (RCPhysics.isAcceleration(v0, v1)) {
                segmentValue = Math.abs(v1);
            } else if (RCPhysics.isDeceleration(v0, v1)) {
                segmentValue = 18.0 - Math.abs(v1);
            }
        }
        return segmentValue;
    }

    @Override
    public String getSegmentValueDescription(double segmentValue) {
        if (segmentValue <= 8.0) {
            return "Accel / Speed " + Logger.format(segmentValue, 1);
        }
        if (segmentValue >= 10.0) {
            return "Decel / Speed " + Logger.format(18.0 - segmentValue, 1);
        }
        return "Constant Speed";
    }
}

