/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.gun.targeter;

import java.awt.geom.Point2D;
import xander.core.Resources;
import xander.core.gun.targeter.Targeter;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;

public class JPCircularTargeter
implements Targeter {
    private SnapshotHistory snapshotHistory = Resources.getSnapshotHistory();
    private int tMinus;

    public JPCircularTargeter(int tMinus) {
        this.tMinus = tMinus;
    }

    @Override
    public String getTargetingType() {
        return "JP Circular";
    }

    @Override
    public boolean canAimAt(Snapshot target) {
        return true;
    }

    @Override
    public double getAim(Snapshot target, Snapshot myself, Wave wave) {
        Snapshot targetTM1 = this.snapshotHistory.getSnapshot(target.getName(), target.getTime() - (long)this.tMinus, false);
        if (targetTM1 == null) {
            targetTM1 = target;
        }
        double distance = 0.0;
        double angleRadians = targetTM1.getHeadingRoboRadians();
        double radianTurn = target.getHeadingRoboRadians() - targetTM1.getHeadingRoboRadians();
        double x = target.getX() - myself.getX();
        double y = target.getY() - myself.getY();
        while ((distance += wave.getBulletVelocity()) < Point2D.distance(0.0, 0.0, x += target.getVelocity() * Math.sin(angleRadians += radianTurn), y += target.getVelocity() * Math.cos(angleRadians))) {
        }
        double aim = RCMath.normalizeDegrees(Math.toDegrees(Math.atan2(x, y)));
        return aim;
    }
}

