/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.track.Wave;
import xander.gfws.segment.AbstractSegmenter;

public class AttackerBearingSegmenter
extends AbstractSegmenter {
    public AttackerBearingSegmenter() {
        super(-180.0, 180.0);
    }

    @Override
    public String getName() {
        return "Defender Heading Segmenter";
    }

    @Override
    public double getSegmentValue(Wave wave) {
        double attackerAtAngle = RCMath.normalizeDegrees(180.0 + wave.getInitialDefenderBearing());
        double defenderHeading = wave.getInitialDefenderSnapshot().getHeadingRoboDegrees();
        if (wave.getInitialDefenderSnapshot().getVelocity() < 0.0) {
            defenderHeading = RCMath.normalizeDegrees(180.0 + defenderHeading);
        }
        return RCMath.getTurnAngle(defenderHeading, attackerAtAngle);
    }

    @Override
    public String getSegmentValueDescription(double segmentValue) {
        return "Attacker bearing " + Logger.format(segmentValue);
    }
}

