/*
 * Decompiled with CFR 0.152.
 */
package xander.paint;

import java.util.HashMap;
import java.util.Map;
import xander.paint.Paintable;
import xander.paint.Painter;

public class Paintables {
    private static final Paintables instance = new Paintables();
    private Map<String, Paintable> paintables = new HashMap<String, Paintable>();
    private Map<Class<?>, Paintable> genericPaintables = new HashMap();

    private Paintables() {
    }

    public static Paintables getInstance() {
        return instance;
    }

    public static void addPaintable(Paintable paintable) {
        instance.add(paintable);
    }

    public static Map<String, Paintable> getPaintables() {
        return Paintables.instance.paintables;
    }

    public static Map<Class<?>, Paintable> getGenericPaintables() {
        return Paintables.instance.genericPaintables;
    }

    public Paintable getPaintable(Painter<?> painter) {
        Paintable paintable = this.paintables.get(painter.getName());
        if (paintable == null) {
            paintable = this.genericPaintables.get(painter.getPaintableClass());
        }
        return paintable;
    }

    public void add(Paintable paintable) {
        if (paintable.getPainterName() == null) {
            this.genericPaintables.put(paintable.getClass(), paintable);
        } else {
            this.paintables.put(paintable.getPainterName(), paintable);
        }
    }
}

