/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.TreeMap;
import robocode.TeamRobot;
import wcsv.melee.Info;
import wcsv.melee.InfoSet;
import wcsv.melee.Move;
import wcsv.melee.Utils;

public class MinimumRiskMove
implements Move {
    private TeamRobot robot;
    private TreeMap scans;
    private Point2D.Double center;
    private Rectangle2D.Double fieldRect;

    public void registerScan(InfoSet scan) {
        this.scans.put(scan.enemy.basic.name, scan);
    }

    public void operate(InfoSet target) {
        if (target != null && (Math.abs(this.robot.getDistanceRemaining()) < (double)3 || Math.random() < 0.08)) {
            double lowestRisk;
            Info enemy;
            Object[] enemyList = this.scans.values().toArray();
            double angle = 0.0;
            double bestAngle = 0.0;
            double risk = 0.0;
            int i = 0;
            while (i < enemyList.length) {
                enemy = ((InfoSet)enemyList[i]).enemy;
                lowestRisk = enemy.basic.damageDoneToMe / enemy.distance;
                angle += enemy.basic.location.getX() * lowestRisk;
                bestAngle += enemy.basic.location.getY() * lowestRisk;
                risk += lowestRisk;
                ++i;
            }
            Point2D.Double centroid = new Point2D.Double(angle / risk, bestAngle / risk);
            angle = Utils.absoluteAngle(Utils.absoluteAngleToPoint(target.myInfo.basic.location, target.enemy.basic.location) - 1.58);
            lowestRisk = Double.MAX_VALUE;
            double period = Math.random() * 100.0 + 50.0;
            double a = -1.0;
            while (a <= 1.0) {
                double b = 0.0;
                while (b <= Math.PI) {
                    Point2D.Double dest = Utils.projectPoint(target.myInfo.basic.location, angle + 0.7 * a - b, period);
                    risk = this.outsideBufferedWall(dest) ? Utils.distance(this.center, dest) : 1.0 / Math.pow(this.wallDist(dest), 1.9);
                    risk += 1.0 / Math.pow(Utils.distance(centroid, dest), 1.8);
                    risk += 1.0 / Math.pow(Utils.distance(this.center, dest), 1.8);
                    int i2 = 0;
                    while (i2 < enemyList.length) {
                        enemy = ((InfoSet)enemyList[i2]).enemy;
                        double r = Utils.distance(enemy.basic.location, dest);
                        risk += enemy.basic.energy / Math.pow(r, 1.9);
                        ++i2;
                    }
                    if (risk < lowestRisk) {
                        bestAngle = Utils.absoluteAngleToPoint(target.myInfo.basic.location, dest);
                        lowestRisk = risk;
                    }
                    b += Math.PI;
                }
                a += 0.2;
            }
            bestAngle = Utils.relativeAngle(bestAngle - this.robot.getHeadingRadians());
            angle = Math.atan(Math.tan(bestAngle));
            this.robot.setTurnRightRadians(angle);
            this.robot.setAhead(bestAngle == angle ? period : -period);
        }
        if (Math.random() < 0.25) {
            this.robot.setMaxVelocity(Math.random() * 15.0 + (double)2);
        }
    }

    private final double wallDist(Point2D.Double p) {
        return Math.min(Math.min(p.getX(), p.getY()), Math.min(Utils.fWidth - p.getX(), Utils.fHeight - p.getY()));
    }

    private final boolean outsideBufferedWall(Point2D.Double p) {
        double buff = 24.0;
        boolean bl = false;
        if (p.getX() < buff || p.getY() < buff || p.getX() > Utils.fWidth - buff || p.getY() > Utils.fHeight - buff) {
            bl = true;
        }
        return bl;
    }

    public void reset() {
        this.scans.clear();
    }

    public double wallCorrectedAngle(double originalAngle, Point2D.Double loc) {
        double increasingAngle = originalAngle;
        double decreasingAngle = originalAngle;
        int count = 0;
        while (count < 100) {
            if (this.fieldRect.contains(Utils.projectPoint(loc, increasingAngle, 130.0))) {
                return Utils.absoluteAngle(increasingAngle);
            }
            if (this.fieldRect.contains(Utils.projectPoint(loc, decreasingAngle, 130.0))) {
                return Utils.absoluteAngle(decreasingAngle);
            }
            increasingAngle += 0.125;
            decreasingAngle -= 0.125;
            ++count;
        }
        return originalAngle;
    }

    public MinimumRiskMove(TeamRobot r) {
        this.robot = r;
        this.scans = new TreeMap();
        this.center = new Point2D.Double(Utils.fWidth / (double)2, Utils.fHeight / (double)2);
        this.fieldRect = new Rectangle2D.Double(25.0, 25.0, Utils.fWidth - 50.0, Utils.fHeight - 50.0);
    }
}

