/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.awt.Color;
import java.text.NumberFormat;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import shrub.Bearing;
import shrub.Body;
import shrub.BodyInstruction;
import shrub.Gun;
import shrub.GunInstruction;
import shrub.Heading;
import shrub.Location;
import shrub.MultiTracker;
import shrub.Navigator;
import shrub.Phasor;
import shrub.Radar;
import shrub.RadarInstruction;
import shrub.Sighting;
import shrub.Turret;
import shrub.TurretInstruction;

public class Silver
extends AdvancedRobot {
    private String mBotName = "Silver v048";
    private boolean mAllDone = false;
    private Body mBody = new Body();
    private Turret mTurret = new Turret();
    private Gun mGun = new Gun();
    private Radar mRadar = new Radar();
    private Navigator mNavigator = new Navigator();
    private MultiTracker mTracker = new MultiTracker();
    private Phasor sweep3x5 = new Phasor();
    private Phasor sweep3x10 = new Phasor();
    private Phasor trackSweep = new Phasor();
    private Phasor trackScan = new Phasor();
    private long mNumLoopIterations = 0L;
    private long mTotalLoopTime = 0L;
    private long mMaxLoopTime = 0L;
    private long mMinLoopTime = 999999L;
    private double mAvgLoopTime = 0.0;
    private long mTotalExecTime = 0L;
    private long mMaxExecTime = 0L;
    private long mMinExecTime = 999999L;
    private double mAvgExecTime = 0.0;
    private long mNumTurnsSkipped = 0L;
    private long mNumShotsFired = 0L;
    private long mNumShotsHit = 0L;
    private long mNumShotsMissed = 0L;
    private long mFirstShotTime = 0L;
    private long mLastShotTime = 0L;
    private double mAvgeShotPower = 0.0;
    private double mAvgeShotInterval = 0.0;
    private long mNumEnergyCaps = 0L;
    private long mNumCoupsDeGras = 0L;
    NumberFormat dp2 = NumberFormat.getInstance();

    public void Initialise() {
        this.setColors(Color.white, Color.darkGray, Color.white);
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
        this.mAllDone = false;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.mBody.Initialise();
        this.mTurret.Initialise();
        this.mGun.Initialise();
        this.mRadar.Initialise();
        this.mNavigator.Initialise();
        this.mTracker.Initialise();
        this.mTracker.SetRadarRef(this.mRadar);
        this.mNavigator.SetTrackerRef(this.mTracker);
        this.mBody.SetNavigatorRef(this.mNavigator);
        this.mNavigator.SetBattlefieldSize(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.mTracker.SetPhasorResetOnTargetChange(true);
        double[] sweep3x5Array = new double[]{0.0, -5.0, -10.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 10.0, 5.0};
        this.sweep3x5.SetPhaseArray(sweep3x5Array);
        double[] sweep3x10Array = new double[]{0.0, -10.0, -20.0, -30.0, -30.0, -20.0, -10.0, 0.0, 10.0, 20.0, 30.0, 30.0, 20.0, 10.0};
        this.sweep3x10.SetPhaseArray(sweep3x10Array);
        double[] tswArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 45.0, 90.0, 90.0, 45.0, 0.0, -45.0, -90.0, -90.0, -45.0};
        this.trackSweep.SetPhaseArray(tswArray);
        double[] tscArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};
        this.trackScan.SetPhaseArray(tscArray);
        double robotWidth = this.getWidth();
        double robotHeight = this.getHeight();
        double robotRadius = (robotWidth + robotHeight) / 4.0;
        Location myLocn = new Location();
        myLocn.Set(this.getX(), this.getY());
        double gunHeat = this.getGunHeat();
        this.mBody.SetMode(2);
        this.mBody.SetRobotRadius(robotRadius);
        this.mBody.SetMaxWaypointDuration(20L);
        this.mBody.SetWaypointLocn(myLocn);
        this.mBody.SetAllowReversal(true);
        this.mTurret.SetMode(0);
        this.mTurret.SetRotateSpeed(20.0);
        this.mTurret.SetPhasor(this.sweep3x5);
        this.mGun.SetMode(0);
        this.mGun.SetGunHeat(gunHeat);
        long timeFirstFireAllowed = this.mGun.HowLongTillReady();
        this.mRadar.SetMode(2);
        this.mRadar.SetScanSpeed(45.0);
        this.mRadar.SetPhasor(this.trackScan);
        this.mNavigator.SetWallAvoidDistance(100.0);
        this.mNavigator.SetStepLength(100.0);
        this.mNavigator.SetNumPaths(16);
        System.out.println();
        System.out.println("-*- " + this.mBotName + " -*-");
        System.out.print("Start locn:   ");
        myLocn.Print();
        System.out.println();
        System.out.println("Robot width:  " + this.dp2.format(robotWidth));
        System.out.println("Robot height: " + this.dp2.format(robotHeight));
        System.out.println("Robot radius: " + this.dp2.format(robotRadius));
        System.out.println("Fire allowed: " + timeFirstFireAllowed);
        this.mNumLoopIterations = 0L;
        this.mTotalLoopTime = 0L;
        this.mMaxLoopTime = 0L;
        this.mMinLoopTime = 999999L;
        this.mAvgLoopTime = 0.0;
        this.mTotalExecTime = 0L;
        this.mMaxExecTime = 0L;
        this.mMinExecTime = 999999L;
        this.mAvgExecTime = 0.0;
        this.mNumLoopIterations = 0L;
        this.mNumTurnsSkipped = 0L;
        this.mNumShotsFired = 0L;
        this.mNumShotsHit = 0L;
        this.mNumShotsMissed = 0L;
        this.mFirstShotTime = 0L;
        this.mLastShotTime = 0L;
        this.mAvgeShotPower = 0.0;
        this.mAvgeShotInterval = 0.0;
        this.mNumEnergyCaps = 0L;
        this.mNumCoupsDeGras = 0L;
    }

    public void run() {
        long numIterations = 0L;
        long currentTime = 0L;
        long timeFirstFireAllowed = 0L;
        long numOpponents = 0L;
        Location myLocn = new Location();
        double currentEnergy = 0.0;
        double gunHeat = 0.0;
        double bodyHeading = 0.0;
        double gunHeading = 0.0;
        double radarHeading = 0.0;
        this.Initialise();
        while (!this.mAllDone) {
            Sighting target;
            ++this.mNumLoopIterations;
            currentTime = this.getTime();
            currentEnergy = this.getEnergy();
            numOpponents = this.getOthers();
            myLocn.Set(this.getX(), this.getY());
            bodyHeading = this.getHeading();
            gunHeading = this.getGunHeading();
            gunHeat = this.getGunHeat();
            radarHeading = this.getRadarHeading();
            this.mBody.SetRobotLocn(myLocn);
            this.mBody.SetRobotHdng(bodyHeading);
            this.mBody.SetTimeNow(currentTime);
            this.mTurret.SetTurretHdng(gunHeading);
            this.mTurret.SetTurretLocn(myLocn);
            this.mTurret.SetTime(currentTime);
            this.mGun.SetGunHdng(gunHeading);
            this.mGun.SetGunLocn(myLocn);
            this.mGun.SetGunHeat(gunHeat);
            this.mGun.SetTime(currentTime);
            this.mRadar.SetRadarHdng(radarHeading);
            this.mRadar.SetRadarLocn(myLocn);
            this.mRadar.SetTime(currentTime);
            this.mTracker.SetCurrentTime(currentTime);
            this.mTracker.SetTrackerLocn(myLocn);
            this.mTracker.ChooseCurrentTarget();
            if (currentTime < timeFirstFireAllowed - 10L) {
                this.mRadar.SetMode(2);
                this.mRadar.SetScanSpeed(45.0);
            } else if (this.mTracker.HasLockOn()) {
                if (numOpponents < 2L) {
                    target = this.mTracker.GetCurrentTarget();
                    this.mRadar.SetMode(5);
                    this.mRadar.SetTargetLocn(target.GetLocation());
                    this.mRadar.SetScanSpeed(45.0);
                } else {
                    target = this.mTracker.GetCurrentTarget();
                    this.mRadar.SetMode(9);
                    this.mRadar.SetTargetLocn(target.GetLocation());
                    this.mRadar.SetScanSpeed(45.0);
                }
            } else {
                this.mRadar.SetMode(2);
                this.mRadar.SetScanSpeed(45.0);
            }
            if (this.mTracker.HasLockOn()) {
                target = this.mTracker.GetCurrentTarget();
                Heading hdngToTarget = new Heading();
                hdngToTarget.SetFromTo(myLocn, target.GetLocation());
                double perpVel = hdngToTarget.CrossComponent(target.GetHeading(), target.GetVelocity());
                if (Math.abs(perpVel) < 1.5) {
                    this.mTurret.SetMode(6);
                    this.mTurret.SetTargetHdng(hdngToTarget);
                } else {
                    Heading leadTarget = new Heading();
                    leadTarget.Set(hdngToTarget);
                    if (perpVel < 0.0) {
                        leadTarget.Adjust(-20.0);
                    } else {
                        leadTarget.Adjust(20.0);
                    }
                    this.mTurret.SetMode(7);
                    this.mTurret.SetTargetHdng(leadTarget);
                    this.mTurret.SetRotateSpeed(20.0);
                }
            } else {
                this.mTurret.SetMode(0);
            }
            if (this.mTracker.HasLockOn()) {
                target = this.mTracker.GetCurrentTarget();
                double maxPower = Gun.MaxLegalPower();
                double minPower = Gun.MinLegalPower() + 0.4;
                if (target.GetEnergy() < 1.0E-4) {
                    maxPower = Gun.MinLegalPower();
                    minPower = Gun.MinLegalPower();
                    ++this.mNumCoupsDeGras;
                } else if (currentEnergy <= maxPower) {
                    maxPower = currentEnergy - 0.01;
                    if (maxPower < minPower) {
                        minPower = maxPower;
                    }
                    ++this.mNumEnergyCaps;
                }
                this.mGun.SetMode(1);
                this.mGun.SetTargetInfo(target);
                this.mGun.SetMinPower(minPower);
                this.mGun.SetMaxPower(maxPower);
            } else {
                this.mGun.SetMode(0);
                this.mGun.ClearTargetInfo();
            }
            BodyInstruction[] bodyInstructArray = this.mBody.Process();
            int index = 0;
            int numElements = bodyInstructArray.length;
            while (index < numElements) {
                this.ResolveBodyInstruct(bodyInstructArray[index]);
                ++index;
            }
            TurretInstruction turretInstruct = this.mTurret.Process();
            this.ResolveTurretInstruct(turretInstruct);
            RadarInstruction radarInstruct = this.mRadar.Process();
            this.ResolveRadarInstruct(radarInstruct);
            GunInstruction gunInstruct = this.mGun.Process();
            if (gunInstruct.IsFire()) {
                double power = gunInstruct.GetDouble();
                this.UpdateFiringStats(currentTime, power);
            }
            this.ResolveGunInstruct(gunInstruct);
            if (gunInstruct.IsFire()) continue;
            this.execute();
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++this.mNumTurnsSkipped;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.mNumShotsHit;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.mNumShotsMissed;
    }

    public void onDeath(DeathEvent event) {
        System.out.println();
        System.out.println("=X==X= DEATH =X==X=");
        this.PrintStats();
    }

    public void onWin(WinEvent event) {
        System.out.println();
        System.out.println("=@==@= VICTORY =@==@=");
        this.PrintStats();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        long contactTime = event.getTime();
        String contactName = event.getName();
        Heading robotHdng = new Heading();
        robotHdng.Set(this.getHeading());
        Bearing bearingTo = new Bearing();
        bearingTo.Set(event.getBearing());
        double distanceTo = event.getDistance();
        Heading contactHdng = new Heading();
        contactHdng.Set(event.getHeading());
        double contactEnergy = event.getEnergy();
        double contactVelocity = event.getVelocity();
        Heading headingTo = new Heading();
        headingTo.Set(robotHdng);
        headingTo.Adjust(bearingTo);
        Location robotLocn = new Location();
        robotLocn.SetX(this.getX());
        robotLocn.SetY(this.getY());
        Location contactLocn = new Location();
        contactLocn.SetRelative(robotLocn, headingTo, distanceTo);
        int contactInaccuracy = 0;
        Sighting sighting = new Sighting();
        sighting.SetName(contactName);
        sighting.SetLocation(contactLocn);
        sighting.SetHeading(contactHdng);
        sighting.SetVelocity(contactVelocity);
        sighting.SetEnergy(contactEnergy);
        sighting.SetInaccuracy(contactInaccuracy);
        sighting.SetTimestamp(contactTime);
        this.mTracker.ReportSighting(sighting);
    }

    public void onHitWall(HitWallEvent event) {
        this.mBody.ActOnRobotHitWall(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.mBody.ActOnRobotHitRobot(event);
        String contactName = event.getName();
        Bearing brngToContact = new Bearing();
        brngToContact.Set(event.getBearing());
        long contactTime = event.getTime();
        Heading myHdng = new Heading();
        myHdng.Set(this.mBody.GetRobotHdng());
        Heading hdngToContact = new Heading();
        hdngToContact.Set(myHdng);
        hdngToContact.Adjust(brngToContact);
        double centreDistance = 2.0 * this.mBody.GetRobotRadius();
        Location myLocn = new Location();
        myLocn.Set(this.mBody.GetRobotLocn());
        Location contactLocn = new Location();
        contactLocn.SetRelative(myLocn, hdngToContact, centreDistance);
        double contactVelocity = 0.0;
        Heading contactHdng = new Heading();
        contactHdng.Set(hdngToContact);
        contactHdng.Flip();
        double contactEnergy = 50.0;
        int contactInaccuracy = 1;
        Sighting sighting = new Sighting();
        sighting.SetName(contactName);
        sighting.SetLocation(contactLocn);
        sighting.SetHeading(contactHdng);
        sighting.SetVelocity(contactVelocity);
        sighting.SetEnergy(contactEnergy);
        sighting.SetInaccuracy(contactInaccuracy);
        sighting.SetTimestamp(contactTime);
        this.mTracker.ReportSighting(sighting);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.mBody.ActOnHitByBullet(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.mTracker.ReportRobotDeath(event.getName());
    }

    public boolean ResolveBodyInstruct(BodyInstruction instruct) {
        boolean achieved = false;
        if (!instruct.IsNothing()) {
            if (instruct.IsAchieved()) {
                achieved = true;
            } else if (instruct.IsTurnLeft()) {
                this.setTurnLeft(instruct.GetDouble());
            } else if (instruct.IsTurnRight()) {
                this.setTurnRight(instruct.GetDouble());
            } else if (instruct.IsMoveAhead()) {
                this.setAhead(instruct.GetDouble());
            } else if (instruct.IsMoveBack()) {
                this.setBack(instruct.GetDouble());
            } else if (instruct.IsSpeedLimit()) {
                System.out.println("Speed limit: " + instruct.GetDouble());
                this.setMaxVelocity(instruct.GetDouble());
            } else {
                System.out.println("ERROR : Robot::ResolveBodyInstruct, unexpected mode");
            }
        }
        return achieved;
    }

    public boolean ResolveTurretInstruct(TurretInstruction instruct) {
        boolean achieved = false;
        if (!instruct.IsNothing()) {
            if (instruct.IsAchieved()) {
                achieved = true;
            } else if (instruct.IsRotateLeft()) {
                this.setTurnGunLeft(instruct.GetDouble());
            } else if (instruct.IsRotateRight()) {
                this.setTurnGunRight(instruct.GetDouble());
            } else {
                System.out.println("ERROR : Robot::ResolveTurretInstruct, unexpected mode");
            }
        }
        return achieved;
    }

    public boolean ResolveRadarInstruct(RadarInstruction instruct) {
        boolean achieved = false;
        if (!instruct.IsNothing()) {
            if (instruct.IsAchieved()) {
                achieved = true;
            } else if (instruct.IsRotateLeft()) {
                this.setTurnRadarLeft(instruct.GetDouble());
            } else if (instruct.IsRotateRight()) {
                this.setTurnRadarRight(instruct.GetDouble());
            } else {
                System.out.println("ERROR : Robot::ResolveRadarInstruct, unexpected mode");
            }
        }
        return achieved;
    }

    public boolean ResolveGunInstruct(GunInstruction instruct) {
        boolean achieved = false;
        if (!instruct.IsNothing()) {
            if (instruct.IsAchieved()) {
                achieved = true;
            } else if (instruct.IsFire()) {
                this.fire(instruct.GetDouble());
            } else {
                System.out.println("ERROR : Robot::ResolveGunInstruct, unexpected mode");
            }
        }
        return achieved;
    }

    private final void UpdateFiringStats(long thisTime, double thisPower) {
        if (this.mNumShotsFired <= 0L) {
            this.mAvgeShotInterval = thisTime;
            this.mAvgeShotPower = thisPower;
            this.mNumShotsFired = 1L;
            this.mFirstShotTime = thisTime;
            this.mLastShotTime = thisTime;
        } else if (this.mNumShotsFired == 1L) {
            double totalPowerSoFar = this.mAvgeShotPower + thisPower;
            double totalIntervalSoFar = thisTime - this.mLastShotTime;
            ++this.mNumShotsFired;
            this.mAvgeShotPower = totalPowerSoFar / (double)this.mNumShotsFired;
            this.mAvgeShotInterval = totalIntervalSoFar / (double)(this.mNumShotsFired - 1L);
            this.mLastShotTime = thisTime;
        } else {
            long thisInterval = thisTime - this.mLastShotTime;
            double totalPowerSoFar = this.mAvgeShotPower * (double)this.mNumShotsFired + thisPower;
            double totalIntervalSoFar = this.mAvgeShotInterval * (double)(this.mNumShotsFired - 1L) + (double)thisInterval;
            ++this.mNumShotsFired;
            this.mAvgeShotPower = totalPowerSoFar / (double)this.mNumShotsFired;
            this.mAvgeShotInterval = totalIntervalSoFar / (double)(this.mNumShotsFired - 1L);
            this.mLastShotTime = thisTime;
        }
    }

    private final void PrintStats() {
        double hitPercent = 0.0;
        long totalResolvedShots = this.mNumShotsHit + this.mNumShotsMissed;
        if (totalResolvedShots > 0L) {
            hitPercent = 100.0 * (double)this.mNumShotsHit / (double)totalResolvedShots;
        }
        long numWpTimeouts = this.mBody.GetNumWaypointTimeouts();
        long numTimesRammer = this.mBody.GetNumTimesRammer();
        long numTimesRammee = this.mBody.GetNumTimesRammee();
        long numTimesHitWall = this.mBody.GetNumTimesHitWall();
        long numTimesHitByBullet = this.mBody.GetNumTimesHitByBullet();
        System.out.println();
        System.out.println("---My shooting---");
        System.out.println("Shots/Hit/Miss:  " + this.mNumShotsFired + " / " + this.mNumShotsHit + " / " + this.mNumShotsMissed);
        System.out.println("Hit percent:     " + this.dp2.format(hitPercent) + "%");
        System.out.println("First/Last shot: " + this.mFirstShotTime + " / " + this.mLastShotTime);
        System.out.println("Avg Time/Power:  " + this.dp2.format(this.mAvgeShotInterval) + " / " + this.dp2.format(this.mAvgeShotPower));
        System.out.println("---Collisions---");
        System.out.println("Hit by bullet    " + numTimesHitByBullet);
        System.out.println("Ram by Me/Other: " + numTimesRammer + " / " + numTimesRammee);
        System.out.println("Bumped wall      " + numTimesHitWall);
        System.out.println("---Other stuff---");
        System.out.println("Caps/Coups:      " + this.mNumEnergyCaps + " / " + this.mNumCoupsDeGras);
        System.out.println("Timeouts:        " + numWpTimeouts);
        System.out.println("Turns skipped:   " + this.mNumTurnsSkipped);
        System.out.println();
    }
}

