/*
 * Decompiled with CFR 0.152.
 */
package mladjo;

import Svasta.Wave;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class AIR
extends AdvancedRobot {
    List waves = new ArrayList();
    int direction = 1;
    int[] stats = new int[31];
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;
    private int lastScan = 20;
    static double hostileAbsoluteBearing;

    public void run() {
        this.setBodyColor(Color.yellow);
        this.setGunColor(Color.yellow);
        this.setScanColor(Color.yellow);
        this.setRadarColor(Color.yellow);
        this.setBulletColor(Color.orange);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.scanning();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        hostileAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.lastScan = 0;
        this.setBodyColor(Color.black);
        this.setGunColor(Color.black);
        this.setScanColor(Color.black);
        this.setRadarColor(Color.black);
        this.setBulletColor(Color.red);
        this.robotLocation = new Point2D.Double(this.getX(), this.getY());
        this.enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.enemyDistance = e.getDistance();
        this.enemyLocation = AIR.vectorToLocation(this.enemyAbsoluteBearing, this.enemyDistance, this.robotLocation);
        this.move();
        double hostileX = this.getX() + Math.sin(hostileAbsoluteBearing) * e.getDistance();
        double hostileY = this.getY() + Math.cos(hostileAbsoluteBearing) * e.getDistance();
        int i = 0;
        while (i < this.waves.size()) {
            Wave currentWave = (Wave)this.waves.get(i);
            if (currentWave.checkHit(hostileX, hostileY, (int)this.getTime())) {
                this.waves.remove(currentWave);
                --i;
            }
            ++i;
        }
        double power = Math.min(2.0, e.getEnergy() / 5.0);
        if (e.getVelocity() != 0.0) {
            this.direction = Math.sin(e.getHeadingRadians() - hostileAbsoluteBearing) * e.getVelocity() < 0.0 ? -1 : 1;
        } else if (e.getEnergy() <= 0.0) {
            this.setBodyColor(Color.red);
            this.setGunColor(Color.red);
            this.setRadarColor(Color.red);
            this.turnRight(e.getBearing());
            this.ahead(e.getDistance() + 5.0);
        }
        int[] currentStats = this.stats;
        Wave newWave = new Wave(this.getX(), this.getY(), hostileAbsoluteBearing, power, this.direction, (int)this.getTime(), currentStats);
        int bestindex = 15;
        int i2 = 0;
        while (i2 < 31) {
            if (currentStats[bestindex] < currentStats[i2]) {
                bestindex = i2;
            }
            ++i2;
        }
        double guessFactor = (double)(bestindex - (this.stats.length - 1) / 2) / (double)((this.stats.length - 1) / 2);
        double angleOffset = (double)this.direction * guessFactor * newWave.maxEscapeAngle();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(hostileAbsoluteBearing - this.getGunHeadingRadians() + angleOffset)));
        if (this.setFireBullet(power) != null) {
            this.waves.add(newWave);
        }
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 200) {
            Color robotColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color gunColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color radarColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.setColors(robotColor, gunColor, radarColor);
            this.setTurnGunRight(Double.POSITIVE_INFINITY);
            this.setTurnLeft(Double.POSITIVE_INFINITY);
            this.execute();
            ++i;
        }
    }

    public void scanning() {
        ++this.lastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.lastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - hostileAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.04;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public int sign(double x) {
        if (x > 0.0) {
            return 1;
        }
        return -1;
    }

    void move() {
        this.considerChangingDirection();
        Point2D robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = AIR.vectorToLocation(AIR.absoluteBearing(this.enemyLocation, this.robotLocation) + this.movementLateralAngle, this.enemyDistance * (1.1 - tries / 100.0), this.enemyLocation);
        } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(25.0).contains(robotDestination));
        this.goTo(robotDestination);
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(AIR.absoluteBearing(this.robotLocation, destination) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(this.robotLocation.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return AIR.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}

