/*
 * Decompiled with CFR 0.152.
 */
package rdt199.util;

import rdt199.util.BotFuncs;
import rdt199.util.Location;
import robocode.ScannedRobotEvent;

public class RobotSnapshot {
    public Location m_Location;
    public double m_dAngle;
    public double m_dDeltaAngle;
    public double m_dVelocity;
    public double m_dDeltaVelocity;
    public double m_dEnergy;
    public long m_lTime;

    public RobotSnapshot() {
        this.m_Location = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        this.m_dVelocity = BotFuncs.m_AdvancedRobot.getVelocity();
        this.m_dAngle = BotFuncs.m_AdvancedRobot.getHeading();
        this.m_dEnergy = BotFuncs.m_AdvancedRobot.getEnergy();
        this.m_lTime = BotFuncs.m_AdvancedRobot.getTime();
        this.m_dDeltaAngle = 0.0;
    }

    public RobotSnapshot(ScannedRobotEvent e) {
        this.m_Location = new Location(this.getX(e), this.getY(e));
        this.m_dVelocity = e.getVelocity();
        this.m_dAngle = e.getHeading();
        if (this.m_dVelocity < 0.0) {
            this.m_dAngle = BotFuncs.normaliseAbsDegrees(this.m_dAngle + 180.0);
            this.m_dVelocity = Math.abs(this.m_dVelocity);
        }
        this.m_dEnergy = e.getEnergy();
        this.m_lTime = BotFuncs.m_AdvancedRobot.getTime();
        this.m_dDeltaAngle = 0.0;
    }

    public double similar(RobotSnapshot snap) {
        double dVelocityDiff = Math.abs(Math.abs(this.m_dVelocity) - Math.abs(snap.m_dVelocity));
        double dVelocityScore = 1.0;
        if (dVelocityDiff != 0.0) {
            dVelocityScore = 1.0 - dVelocityDiff / 8.0;
        }
        double dDeltaAngleDiff = Math.abs(this.m_dDeltaAngle - snap.m_dDeltaAngle);
        double dDeltaAngleScore = 1.0;
        if (dDeltaAngleDiff != 0.0) {
            dDeltaAngleScore = 1.0 - dDeltaAngleDiff / 10.0;
        }
        return dVelocityScore + dDeltaAngleScore;
    }

    private double getX(ScannedRobotEvent event) {
        return event.getDistance() * Math.sin(Math.toRadians(BotFuncs.m_AdvancedRobot.getHeading() + event.getBearing())) + BotFuncs.m_AdvancedRobot.getX();
    }

    private double getY(ScannedRobotEvent event) {
        return event.getDistance() * Math.cos(Math.toRadians(BotFuncs.m_AdvancedRobot.getHeading() + event.getBearing())) + BotFuncs.m_AdvancedRobot.getY();
    }
}

