/*
 * Decompiled with CFR 0.152.
 */
package ultra.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jdg.tools.BotTrigo;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import ultra.core.BotDump;
import ultra.core.LogEntry;
import ultra.core.RemoteBot;
import ultra.core.UltraLogManager;
import ultra.core.Utils;

public abstract class Skeleton
extends AdvancedRobot
implements RemoteBot {
    protected static final boolean DEBUG = false;
    private double WALL_STICK = 80.0;
    protected Rectangle2D.Double arena;
    protected boolean is1v1;
    protected UltraLogManager log = new UltraLogManager();
    private final Utils.MovingStrat targetMovingStrat = Utils.MovingStrat.UNKONWN;
    protected double aheadCoef = 1.0;
    private boolean isFastAcquiring = false;
    private boolean isWallAvoiding = false;
    private double hitByBulletCount = 0.0;
    private double hitByRobotCount = 0.0;
    private double radarCover = 8.0;

    public final void run() {
        this.initialize();
        this.doFirstMoves();
        while (true) {
            this.WALL_STICK = this.getVelocity() * 10.0 + 50.0;
            if (Math.abs(this.getRadarTurnRemaining()) < 1.0E-4) {
                this.setTurnRadarRight(360.0);
            }
            BotDump r = new BotDump(this);
            this.doWallCheck(r);
            if (!this.isWallAvoiding() || !(Math.abs(this.getDistanceRemaining()) > 0.0)) {
                this.doMove(r);
            }
            if (Math.abs(this.getDistanceRemaining()) == 0.0) {
                this.scan();
            }
            this.doTick();
            this.execute();
        }
    }

    protected void doTick() {
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        BotDump r = new BotDump(this);
        LogEntry latestEnnemyLoc = null;
        try {
            latestEnnemyLoc = this.doLog(r, e);
        }
        catch (Exception e2) {
            System.err.println("doLog has failed");
            e2.printStackTrace();
        }
        try {
            this.doRadar(r, latestEnnemyLoc);
        }
        catch (Exception e2) {
            System.err.println("doRadar has failed");
            e2.printStackTrace();
        }
        try {
            this.doGun(r);
        }
        catch (Exception e2) {
            System.err.println("doGun has failed");
            e2.printStackTrace();
        }
        if (!this.isWallAvoiding) {
            this.doMove(r);
        }
    }

    protected void onRobotFired(double bulletPower) {
    }

    private final LogEntry doLog(BotDump r, ScannedRobotEvent e) {
        double energyLoss;
        LogEntry current = this.log.log(r, e);
        LogEntry previous = this.log.reverseGet(1);
        if (previous != null && (energyLoss = previous.energy - current.energy) > 0.0 && energyLoss <= 3.0) {
            this.onRobotFired(energyLoss);
        }
        this.doParseLogs();
        return current;
    }

    protected void doFirstMoves() {
        this.startFastAquisition();
    }

    protected abstract void doGun(BotDump var1);

    protected abstract void doMove(BotDump var1);

    protected abstract void doParseLogs();

    protected void doRadar(BotDump r, LogEntry l) {
        double heading = Utils.getHeadingTo(r, l);
        if (!this.isFastAcquiring) {
            Utils.rotateRadar(r, heading + this.radarCover);
            this.radarCover = -this.radarCover;
        } else {
            Utils.rotateRadar(r, heading);
        }
        if (this.isFastAcquiring) {
            this.stopFastAquisition();
        }
    }

    protected abstract void doAvoidWall(BotDump var1);

    protected abstract Color getBotColor();

    protected Point2D getWallStick1(BotDump r) {
        return BotTrigo.getPosition(r, r.getHeading() - 15.0, this.getWallStick());
    }

    protected Point2D getWallStick2(BotDump r) {
        return BotTrigo.getPosition(r, r.getHeading() + 15.0, this.getWallStick());
    }

    private final void doWallCheck(BotDump r) {
        if (!this.arena.contains(this.getWallStick1(r)) || !this.arena.contains(this.getWallStick2(r))) {
            this.isWallAvoiding = true;
            this.doAvoidWall(r);
        } else if (this.isWallAvoiding) {
            this.isWallAvoiding = false;
        }
    }

    protected boolean isWallAvoiding() {
        return this.isWallAvoiding;
    }

    protected final void startFastAquisition() {
        this.isFastAcquiring = true;
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(false);
        this.setTurnRadarRight(360.0);
        this.setTurnGunRight(180.0);
        this.setTurnRight(90.0);
    }

    protected final void stopFastAquisition() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.isFastAcquiring = false;
    }

    protected void initialize() {
        this.is1v1 = this.getOthers() == 1;
        this.arena = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setAllColors(this.getBotColor());
    }

    @Override
    public void setAhead(double distance) {
        if (distance < 0.0) {
            this.aheadCoef *= -1.0;
        }
        super.setAhead(Math.abs(distance) * this.aheadCoef);
    }

    @Override
    public void reverse() {
        this.aheadCoef *= -1.0;
        this.setAhead(Math.abs(this.getDistanceRemaining()));
    }

    protected double getWallStick() {
        return this.WALL_STICK * this.aheadCoef;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.hitByBulletCount += 1.0;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.hitByRobotCount += 1.0;
    }

    protected double getHitByBulletCount() {
        return this.hitByBulletCount;
    }

    protected double getHitByRobotCount() {
        return this.hitByRobotCount;
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
    }

    public Utils.MovingStrat getTargetMovingStrat() {
        return this.targetMovingStrat;
    }

    public Rectangle2D.Double getArena() {
        return this.arena;
    }

    public void setAheadCoef(double d) {
        this.aheadCoef = d;
    }
}

