package shinh;

import robocode.*;

import java.util.Vector;
import java.awt.geom.Point2D;

public class BulletMgr extends Vector {
	private Entangled ent;

	private PredictArc arcPredict;

	public BulletMgr() {
		super(100);
		ent = Entangled.me;
		arcPredict = new PredictArc();
	}

	public void update() {
		Entangled ent = Entangled.me;

		Vector removes = new Vector();

		for (int i = 0; i < size(); i++) {
			EnemyBullet eb = getBullet(i);
			eb.x += eb.vx;
			eb.y += eb.vy;

			if (eb.x < 0 || eb.x > ent.fieldW || eb.y < 0 || eb.y > ent.fieldH)
				removes.add(eb);
		}

		removeAll(removes);
	}

	public EnemyBullet getBullet(int index) {
		return (EnemyBullet)get(index);
	}

	public void addBullet(Enemy ene, ScannedRobotEvent ev, double pow) {
		Entangled ent = Entangled.me;

		if (ent.getTime() > ene.turn + 8) return;

		if (ent.getOthers() > 1 && ene.name != ent.lastBulletedName) {
			double minlen = 1000000;
			for (int i = 0; i < ent.emgr.size(); i++) {
				Enemy e = ent.emgr.get(i);
				if (e == ene) continue;
				double len = Util.distance2(e.x, e.y, ene.x, ene.y);
				if (minlen > len) minlen = len;
			}
			if (minlen < Util.distance2(ene.x, ene.y, ent.getX(), ent.getY()))
				return;
		}

		EnemyBullet eb1 = new EnemyBullet();
		eb1.x = ene.x;
		eb1.y = ene.y;
/*
		EnemyBullet eb2 = new EnemyBullet();
		EnemyBullet eb3 = new EnemyBullet();
		eb1.x = eb2.x = eb3.x = ene.x;
		eb1.y = eb2.y = eb3.y = ene.y;
*/
		double v = 20 + 3 * pow;
		double dx = ent.getX() - ene.x;
		double dy = ent.getY() - ene.y;
		double d = Util.length(dx, dy);

		eb1.vx = v * dx / d;
		eb1.vy = v * dy / d;
		int t = (int)(d/v);
		eb1.hitTurn = t + ent.getTime();

/*
		ent.pattern.calc(t);
		if (ent.pattern.point != PatternMatcher.NO_MATCH) {
			ent.pattern.guess(t);
			dx = ent.pattern.x;
			dy = ent.pattern.y;

			eb2.vx = v * dx / d;
			eb2.vy = v * dy / d;
			eb2.hitTurn = d / v + ent.getTime();

			add(eb2);
		}
*/
/*
		Point2D.Double pnt = arcPredict.getFuturePnt(ent.self, pow);
		eb3.vx = v * pnt.x / d;
		eb3.vy = v * pnt.y / d;
		eb3.hitTurn = d / v + ent.getTime();
*/
		add(eb1);

//		add(eb3);
	}
}

