/*
 * Created on 2004-10-9
 */
package tide.pear;

import java.awt.geom.Point2D;

import tide.BulletHitEvent;
import tide.EventListener;
import tide.RobotConsole;
import tide.ScannedRobotEvent;
import tide.pear.statistic.EnemyStatistManager;
import tide.util.BotInfo;
import tide.util.BotInfoManager;
import tide.util.MathUtils;
import tide.util.Statist;
import tide.util.StatistUtils;
import tide.util.Wave;
import tide.util.WaveManager;

/**
 * Statist Gun.Shoot enemy by guess factors.
 * @author iiley(Chen Jing)
 */
public class StatistGun extends EventListener implements FireStrategy{
	private BotInfoManager infoManager;
	private EnemyStatistManager statistManager;
	private WaveManager    waveManager;
	
	private String enemyName;
	private int    bearingIndex, wallIndex, reverseWallIndex, distIndex, velocityIndex, lastVelocityIndex, moveTimeIndex;
	
	public static final int    MOVETIME_GAP = 8;
	public static final double NORMAL_POWER = 1.9d;
	private int moveTime;	

	private double firePower = NORMAL_POWER;
	private double gunTurn;
	
	private Wave currentWave;
	private boolean isFired;
	private BotInfo myInfo;
	private BotInfo enemyInfo;
	
	/**
	 * @param console
	 */
	public StatistGun(RobotConsole console) {
		super(console);
		this.infoManager = Pear.getBotInfoRecorder().getBotInfoManager();
		statistManager = new EnemyStatistManager(31);
		waveManager = new WaveManager();
	}
	

	/**
	 * @param statistManager The statistManager to set.
	 */
	protected void setStatistManager(EnemyStatistManager statistManager) {
		this.statistManager = statistManager;
	}
	/* (non-Javadoc)
	 * @see tide.pear.FireStrategy#getFireHeading(double)
	 */
	public double getFireHeading(double power) {
		if(enemyInfo.getEnergy() == 0d){
			return enemyInfo.getAbsBearing();
		}else{
			return currentWave.getHighestFactorHeading();
		}
	}
	/* (non-Javadoc)
	 * @see tide.pear.FireStrategy#onFire()
	 */
	public void onFire() {
		Wave lastWave = waveManager.getLastLastWave();
		if(lastWave != null){
			lastWave.setRateTimes(3);
			lastWave.setRealBullet(true);
		}
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onWork()
	 */
	public void onWork() {
		//isFired = fire();
		
		updateStatist();
		
		/*if(isFired){
			onFire();
		}
		turnGun();*/
	}
	/**
	 * 
	 */
	private void updateStatist() {
		enemyInfo = infoManager.getInfo(enemyName, 
				console.getTime());
		myInfo = infoManager.getInfo(console.getName()+enemyName, 
				console.getTime());
		BotInfo lastEnemyInfo = infoManager.getInfo(enemyName, 
				console.getTime() - 1);
		
		if(enemyInfo == null || myInfo == null || lastEnemyInfo == null)
			return;
		
		Point2D myPos = new Point2D.Double(console.getX(), console.getY());
		waveManager.test(console.getTime(), enemyInfo.getLocation());
		
		firePower = NORMAL_POWER;
		if(enemyInfo.getDistance() <= 200){
			firePower = 3d;
		}
		firePower = Math.min(enemyInfo.getEnergy()/4d+0.0001, firePower);

		updateIndexs();
		
		Statist statist = statistManager.getStatists(distIndex, 
				velocityIndex, 
				lastVelocityIndex,
				bearingIndex, 
				wallIndex, 
				moveTimeIndex,
				reverseWallIndex);
		
		Wave wave = new Wave(statist, 
				myInfo.getLocation(), 
				firePower, 
				enemyInfo.getDirection(),
				enemyInfo.getAbsBearing(), 
				enemyInfo.getTime() - 1);

		if(console.getEnergy() > firePower+0.1)
			waveManager.add(wave);
		
		currentWave = wave;
	}


	/**
	 * @return
	 */
	private boolean fire() {
		boolean isFired = false;
		if(console.getFirePrepareTime() <= 0 
				&& Math.toDegrees(Math.abs(gunTurn)) < 20.0001
				&& console.getEnergy() > firePower+0.1){
			isFired = true;
			console.fire(firePower);
		}
		return isFired;
	}


	private void turnGun(){
		
		gunTurn = MathUtils.anglePI(getFireHeading(firePower) - console.getGunHeading());

		if(!isFired)
			console.turnGun(gunTurn);
		else
			console.turnGun(0);
	}
		
	public void onRoundBegin() {
		waveManager.clear();
	}
	
	public void onScannedRobot(ScannedRobotEvent event) {
		if(enemyName == null){
			enemyName = event.getName();
		}
	}
    
    
	/* (non-Javadoc)
	 * @see tide.EventListener#onBulletHit(tide.BulletHitEvent)
	 */
	public void onBulletHit(BulletHitEvent event) {
		//Pear.log("Bullet Hit-------");
		//Pear.log("Bullet Pos : " + new Point2D.Double(event.getX(), event.getY()));
		//Pear.log("Enemy Pos : " + enemyInfo.getLocation());
	}
	//-----------------------------------------------------------

	public double distanceToWall(Point2D p){
		return Math.min(Math.min(p.getX(), console.getMapWidth()-p.getX()),
				Math.min(p.getY(), console.getMapHeight()-p.getY()));
	}
	
	/**
	 * update all statist buffer's indexs
	 */
	private void updateIndexs() {
		BotInfo enemyInfo = infoManager.getInfo(enemyName, 
				console.getTime());
		BotInfo lastEnemyInfo = infoManager.getInfo(enemyName, 
				console.getTime() - 1);
		if(enemyInfo == null || lastEnemyInfo == null)
			return;
		
		double moveHeading = enemyInfo.getVelocity() >= 0 ? enemyInfo.getHeading() :
			MathUtils.anglePI(enemyInfo.getHeading() + Math.PI);
		bearingIndex = getBearingIndex(enemyInfo.getAbsBearing() + Math.PI/2d - moveHeading); //enemyInfo.getDirection() < 0 ? 0 : 1;//
		wallIndex = getWallIndex(myInfo, enemyInfo);
		reverseWallIndex = getWallIndex(myInfo, enemyInfo, -1);
		distIndex = getDistIndex(enemyInfo.getDistance());
		velocityIndex = getVelocityIndex(enemyInfo.getVelocity());
		lastVelocityIndex = getVelocityIndex(lastEnemyInfo.getVelocity());
		//update moveTime index
		double acc = Math.round(Math.abs(enemyInfo.getVelocity())-Math.abs(lastEnemyInfo.getVelocity()));
		int div = (int)Math.ceil((double)MOVETIME_GAP*(enemyInfo.getDistance()/400));
		if (acc < -0.5d){
			moveTime = div;
		}else if(acc > 0.5d){
			moveTime = 0;//div*3 - 1;
		//}else if(myInfoOfEnemyFireTime.getVelocity() == 0d){
			//moveTime = 0;
		}else{
			if(moveTime < div*3 - 1){
				moveTime = div*3 - 1;
			}
			moveTime++;
		}
		//if(Math.abs(enemyInfo.getVelocity() - lastEnemyInfo.getVelocity()) > 0.1){
		//	moveTime = 0;
		//}
		moveTimeIndex = moveTime / div;
		if(moveTimeIndex > EnemyStatistManager.MOVETIME_D - 1){
			moveTimeIndex = EnemyStatistManager.MOVETIME_D-1;
		}
		//moveTime++;
	}
    

	public int getDistIndex(double dist){
		int index = 0;
		if(dist > 200){
			index = 1 + ((int)dist - 200)/180;
		}
		if(index > EnemyStatistManager.DIST_D - 1){
			index = EnemyStatistManager.DIST_D - 1;
		}
		return index;
	}
	
	public int getBearingIndex(double moveBearing){
		double b = MathUtils.anglePI(moveBearing);
		if(b>Math.PI/2d || b<-Math.PI/2d){
			b = MathUtils.anglePI(Math.PI - b);
		}
		b = Math.toDegrees(b);
		/*if(b>0){
			return 0;
		}else{
			return 0;
		}*/
		double sign = b<0d ? -1: 1;
		b = Math.abs(b);
		int index = 0;
		if(b < 5){ 
			index = 0;
		}else if(b < 25){
			index = 1;
		}else{
			index = 2;
		}
		index *= sign;
		index += 2;
		return index;
	}
	
	public int getWallIndex(BotInfo info, BotInfo targetInfo){
		return getWallIndex(info, targetInfo, 1d);
	}
	
	public int getWallIndex(BotInfo info, BotInfo targetInfo, double dir){
		int index = 0;
		double step = StatistUtils.maxEscapAngle(firePower)/(statistManager.WALL_D);
		do{
			double distToWall = distanceToWall(MathUtils.nextPoint(
					info.getLocation(),
					targetInfo.getAbsBearing() + dir*targetInfo.getDirection()*(index+1)*step,
					targetInfo.getDistance()
					));
			if(distToWall < 18){
				break;
			}else{
				index ++;
			}
		}while(index < statistManager.WALL_D);
		return Math.min(index, statistManager.WALL_D -1);
	}
	
	public int getVelocityIndex(double vel){
		double absV = Math.abs(vel);
		int index = 0;
		if(absV<1d){
			index = 0;
		}else{
			index = ((int)absV - 1)/2 + 1;
		}
		if(index > EnemyStatistManager.VELOCITY_D - 1){
			index = EnemyStatistManager.VELOCITY_D - 1;
		}
		return index;
	}
}
