/*
 * Created on 2004-9-26
 */
package tide.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Wave manager,can manage the waves in a round.
 * @author iiley(Chen Jing)
 */
public class WaveManager {

	private List list;
	
	public WaveManager(){
		list = new LinkedList();
	}
	
	/**
	 * Test all waves in this manager.
	 * @param time current time when this method is calling.
	 * @param targetPos the position of target in this time.
	 */
	public void test(long time, Point2D targetPos){
		Iterator ite = list.iterator();
		while(ite.hasNext()){
			Wave wave = (Wave)ite.next();
			wave.test(time, targetPos);
			if(wave.getRemainTime(time, targetPos)<= -2){
				ite.remove();
			}
		}
	}
	
	/**
	 * Return the wave that just hitted target in the time.
	 * @param time
	 * @param targetPos
	 * @return
	 */
	public Wave getHitedWave(long time, Point2D targetPos){
		Iterator ite = list.iterator();
		long minRemainTime = 10000000l;
		Wave hitedWave = null;
		while(ite.hasNext()){
			Wave wave = (Wave)ite.next();
			long remainTime = Math.abs(wave.getRemainTime(time, targetPos));
			if(remainTime < minRemainTime){
				minRemainTime = remainTime;
				hitedWave = wave;
			}
		}
		if(minRemainTime<=2)
			return hitedWave;
		else 
			return null;
	}
	
	/**
	 * @return the last added wave in wave manager
	 */
	public Wave getLastWave(){
		if(list.size() > 0)
			return (Wave)list.get(list.size() - 1);
		else 
			return null;
	}
	
	/**
	 * @return the last added wave in wave manager
	 */
	public Wave getLastLastWave(){
		if(list.size() > 1)
			return (Wave)list.get(list.size() - 2);
		else 
			return null;
	}
	
	public void add(Wave wave){
		list.add(wave);
	}
	
	/**
	 * @return all waves in this manager.
	 */
	public Iterator waves(){
		return list.iterator();
	}
	
	/**
	 * @return all waves fired when a real bullet fired.
	 */
	public List realWaves(){
		List list = new ArrayList();
		Iterator ite = waves();
		while(ite.hasNext()){
			Wave wave = (Wave)ite.next();
			if(wave.isRealBullet()){
				list.add(wave);
			}
		}
		return list;
	}
	
	/**
	 * clear all waves.
	 */
	public void clear(){
		list.clear();
	}
}
