package mbro;
import robocode.*;
import java.awt.Color;

/**
 * Belajar - a robot by (Amru Mubaidillah) 0.0.3
 */
public class BelajarBot extends AdvancedRobot
{
	/**
	 * run: Belajar's default behavior
	 */
	int besarSudut = 45;
	int lastScan = 100;
	public void run() {
		setColors(Color.red,Color.blue,Color.green);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while(true) {
			if (lastScan++ > 1)
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			setTurnLeft(90);
			setAhead(200);
			setTurnRight(90);
			setAhead(200);
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		lastScan = 0;
		double target = (getHeading() + e.getBearing()) % 360;
		if (target < 0) target += 360;
		double sudut = target - getGunHeading();
		if ((sudut > 180) || (sudut < -180)) 
			setTurnGunRight(360 - Math.abs(sudut));
		else 
			setTurnGunRight(sudut);		
		if (e.getDistance() < 50)
			setFire(3);
		else if (e.getDistance() < 100)
			setFire(2);
		else if (e.getDistance() < 150)
			setFire(1);
		else 
			setFire(.5);
		//execute();
		//hitung sudut
		//radar terhadap target
		double sudut2 = target - getRadarHeading();
		if (sudut2 > 180 || sudut2 <-180)
			if (sudut2 < 0)
			{
				setTurnRadarLeft(360 - Math.abs(sudut2) + besarSudut / 2);
			} else
				setTurnRadarRight(360 - Math.abs(sudut2) + besarSudut / 2);
		else
			if (sudut2 < 0)
				setTurnRadarLeft(Math.abs(sudut2) + besarSudut / 2);
			else
				setTurnRadarRight(sudut2 + besarSudut / 2);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		if (getOthers() > 1) {	    
			setTurnLeft(e.getBearing() % 90);
			setAhead(500);
		} else 
			setTurnRight(e.getBearing());
		execute();
	}

	public void onHitRobot(HitRobotEvent event) {
		turnRight(event.getBearing());
		fire(3);
	}
}