/*
 * Created on 28-oct-2004
 * 
 * $Id: WaveEnemiga.java,v 1.1.2.3 2004/11/01 14:32:22 lolo Exp $
 */
package mnt.utils;

import java.awt.geom.Point2D;

import robocode.util.Utils;

class WaveEnemiga {

    double velocidadBala;
    
    boolean isBullet = false;

    Point2D centro;

    double tiempoInicio;

    Point2D posObjetivo;

    double bearingDir;

    double[] GFs;

    double[] HFs;

    int gf;

    int hf;

    public double distanciaAPos(long tiempo, Point2D pos) {
        return centro.distance(pos) - velocidadBala * (tiempo - tiempoInicio);
    }

    public double getDistancia(Point2D loc) {
        return centro.distance(loc);
    }

    public void hit(Point2D pos) {
        int gf = getGF(pos);
        gf = RoboMath.ajustar(gf, 0, MovimientoMinimoRiesgo.FACTORES);

        HFs[gf]++;
    }

    public double riesgo(int gf) {
	    double val = 0;
	    gf = RoboMath.ajustar(gf, 0, MovimientoMinimoRiesgo.FACTORES);
	    
	    val = HFs[gf] / Math.abs(hf - gf) + (GFs[gf] / Math.abs(this.gf - gf)) / 5;
	
	    return val;
	}

    public double riesgo(Point2D target) {
        int gf = getGF(target);
        return riesgo(gf);
    }

    public int getGF(Point2D location) {
        double angle = bearingDir
                * Utils.normalRelativeAngle(RoboMath.absoluteBearing(centro,
                        location)
                        - RoboMath.absoluteBearing(centro, posObjetivo))
                        / RoboMath.maxAnguloDeHuida(velocidadBala);
        int gf = (int) Math.round((angle) * MovimientoMinimoRiesgo.MITAD_FACTORES);
        return gf;
    }

    public boolean pasada(long time, Point2D location) {

        if (velocidadBala * (time - tiempoInicio) >= (centro.distance(location) - 18)) {
            int gf = getGF(location);
            gf = RoboMath.ajustar(gf, 0, MovimientoMinimoRiesgo.FACTORES);
            GFs[gf]++;
            return true;
        }
        return false;
    }

}