package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class StopAndGoL extends AdvancedRobot {
    private double energy = 100.0;
    private int moveAmount = 40;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing, power;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	setTurnGunRightRadians(Utils.normalRelativeAngle(bearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(power = Math.min(600.0 / e.getDistance(), e.getEnergy() / 4.0))) - getGunHeadingRadians()));
	setFire(power);
	
	// Movement
	setTurnRightRadians(e.getBearingRadians() + Math.PI/2);
	if(energy > (energy = e.getEnergy())) {
	    setAhead(moveAmount);
	}
    }
    
    @Override
    public void onHitWall(HitWallEvent e) {
	moveAmount = -moveAmount;
    }
}
