package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class CornerRL extends AdvancedRobot {    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setTurnRadarRight(Double.POSITIVE_INFINITY);
	goCorner();
	while(true) {
	    turnRight(90);
	    ahead(150);
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	// Radar
	setTurnRadarLeft(getRadarTurnRemaining());
	
	// Targeting
	double bearing = getHeadingRadians() + e.getBearingRadians();
	double power = 15.0 * getEnergy() / e.getDistance();
	setTurnGunRightRadians(Utils.normalRelativeAngle(
	    bearing + Math.random() * Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(power)) - getGunHeadingRadians()));
	setFire(power);
    }
    
    public void goCorner() {
	turnLeft(getHeading() % 90);
	ahead(Double.POSITIVE_INFINITY);
	turnRight(90);
	ahead(Double.POSITIVE_INFINITY);
    }
}
