package bvh.tyr;
import robocode.*;
import java.util.*;

public class BewegingsManager implements Constanten {

// wie ben ik en wie is hij?
   static  Tyr    mijnBot;
   static  Doel   mijnDoel;

// variabelen voor strijdperk:
   double  xMax, yMax;

// variabelen voor beweging:
   int     voorwaards;
   int     bewegingsToestand;
   double  botDraaicirkel, calcDraaicirkel;
   double  botLoopafstand, calcLoopafstand;
   double  volgendeStap;

   double  xM, yM, xD, yD, alphaD;

// variabelen voor uitwijkingsbeleid:
   Hashtable kogels          = new Hashtable();
   Kogel     inkomendeKogel  = new Kogel(); // initialiseren omdat een eerste kogelafstand nodig is.

// constructor:
   public BewegingsManager(Tyr bot, Doel doel) {
      mijnBot           = bot;
      mijnDoel          = doel;

      xMax              = mijnBot.getBattleFieldWidth();  xM = xMax/2D; // bepaal info over strijdperk
      yMax              = mijnBot.getBattleFieldHeight(); yM = yMax/2D;

      volgendeStap      = 0;
      voorwaards        = 0;
      bewegingsToestand = RANDOM;
      botDraaicirkel    = standaardDraaicirkel/2D;
      botLoopafstand    = standaardLoopafstand;
   }

/**********************************************************************
*  NAVIGATIE-ROUTINES
**********************************************************************/
/**
*
*/
   public void navigatie() {
      long nu = mijnBot.getTime();
      if ( (nu - mijnDoel.scanTijd) > CountReset) mijnBot.resetBot(); // is een reset nodig?

      inkomendeKogel = meestNabijeKogel(nu);
      if ( inkomendeKogel != null ) { // uitwijken als kogel nabij is!
         ontwijkKogel();
      }
      else if (nu >= volgendeStap) { // intelligente navigatie: bepaal loopafstand en draaihoek.
         switch (bewegingsToestand) {
           case ZOEKHOEK:    beweegRandom(); break;//zoekHoek(); break;
           case AANVAL:      valAan();       break;
           case VERDEDIGING: verdedig();     break;
           case RAMMEN:      ramDoel();      break;
           case RANDOM:      beweegRandom(); break;
           case KLOON:       kloonBeweging();
         }
// en hier volgende tijd voor bepalen nieuwe bewegingsparameters bepalen o.b.v. afstand tot doel 
// en maximale snelheid van een kogel
         volgendeStap  = mijnBot.getTime() + mijnDoel.afstand/20D;

if (mijnBot.debugMode > 1) mijnBot.out.println("Toestand= "+bewegingsToestand +" ; botRichting= "+(mijnBot.getHeadingRadians()+botDraaicirkel)*180/Math.PI + ", loopAfstand= "+(1D-2D*voorwaards)*botLoopafstand);
      }

      ontwijkWanden(); // corrigeer voor eventuele botsing met de wand.
      setBewegingsparameters( botDraaicirkel, botLoopafstand );
if (mijnBot.debugMode > 1) mijnBot.out.println("            ; relRichting= "+Math.toDegrees(botDraaicirkel) + ", afTeLeggen = "+mijnBot.getDistanceRemaining());
   }

   public void bepaalBewegingsmode() {
// bepaal bewegingsmodus:
       if ( mijnBot.radar.getDoelGevonden() )  {
          if (mijnDoel.getAantalIngeslagenKogels() > 3D) {
             mijnDoel.resetAantalIngeslagenKogels();
             bewegingsrichtingOmkeren();
             bewegingsToestand = VERDEDIGING;
             }
          else if (mijnDoel.e >= (1.33 * mijnBot.getEnergy())
                || mijnDoel.afstand < (2D*naderingsAfstand))
             bewegingsToestand = VERDEDIGING;
          else if (mijnDoel.e <  (1.33 * mijnBot.getEnergy())
                || mijnDoel.afstand > (4D*naderingsAfstand))
             bewegingsToestand = AANVAL;
          else  bewegingsToestand = VERDEDIGING;
       }
       else  bewegingsToestand = RANDOM;
   }

/**
*
*/
   public void valAan() {
      double hoekTovDoel;
      if ( Math.random() > 0.66 ) bewegingsrichtingOmkeren();

// naar Doel toe cirkelen indien op te grote afstand:
      if (mijnDoel.afstand > 4D*naderingsAfstand) hoekTovDoel = 31*Math.PI/64D;
      else                                        hoekTovDoel = Math.PI/2D;
// uit Skuld:
      if ( voorwaards>0 ) hoekTovDoel = -hoekTovDoel; // hoek aanpassen bij beweging achteruit
      calcDraaicirkel = mijnDoel.richting + hoekTovDoel;
      calcLoopafstand = standaardLoopafstand;
   } // einde method valAan()

   public void verdedig() {
// van Doel weg cirkelen:
      double hoekTovDoel = 33*Math.PI/64D;
      if ( voorwaards>0 ) hoekTovDoel = -hoekTovDoel;
      calcDraaicirkel = mijnDoel.richting + hoekTovDoel;
      calcLoopafstand = 1000 - mijnDoel.afstand; // hoe dichter bij, des te harder weglopen
   } // einde method verdedig()

   public void beweegRandom() {
      double r        = Math.random();
      calcDraaicirkel = r * mijnDoel.bewegingsrichting + Math.PI/2D;
      calcLoopafstand = r * mijnDoel.afstand/15;
   } // einde method beweegRandom();

   public void ramDoel() {
      if ( voorwaards>0 ) bewegingsrichtingOmkeren();
      calcDraaicirkel = mijnDoel.richting;
      calcLoopafstand = 50D + mijnDoel.afstand;
   } // einde method ramDoel();

   public void kloonBeweging() {
      calcDraaicirkel = mijnDoel.bewegingsrichting + Math.PI/2D;
      calcLoopafstand = ( mijnDoel.v + 1 ) * 5;
   } // einde method kloonBeweging()

/**
* ontwijkWanden(): primitieve manier om wand te ontwijken
*
* v0.1 (31-10-2002)
*/
   public void ontwijkWanden() {
      double xNw, yNw;
      // bereken eindpunt beweging en stuur bij:
      double xBot = mijnBot.getX();
      double yBot = mijnBot.getY();

      xNw = xBot + Math.sin( calcDraaicirkel ) * calcLoopafstand;
      yNw = yBot + Math.cos( calcDraaicirkel ) * calcLoopafstand;

// code om wanden te ontwijken: als nieuwe positie binnen vooraf bepaalde wandafstand
// dan positie spiegelen t.o.v. deze wandafstand.
      xNw = Math.min(xMax - wandAfstand, Math.max(wandAfstand, xNw)) * 2D - xNw;
      yNw = Math.min(yMax - wandAfstand, Math.max(wandAfstand, yNw)) * 2D - yNw;

      botDraaicirkel = Utils.bepaalRichting(xNw, yNw, xBot, yBot) + voorwaards*Math.PI - mijnBot.getHeadingRadians();
      botDraaicirkel = Utils.normaliseBearing( botDraaicirkel );
      if (Math.abs(botDraaicirkel) > Math.PI/2) {// bepaal minimale draaihoek (door evt. van richting te veranderen.
         botDraaicirkel += Math.PI;
         bewegingsrichtingOmkeren();
      }
      botDraaicirkel = Utils.normaliseBearing( botDraaicirkel );
      botLoopafstand = Utils.bepaalAfstand(xNw, yNw, xBot, yBot); // en bereken opnieuw loopafstand
      volgendeStap   = mijnBot.getTime() + botLoopafstand/8D;
   }

/**
* meestNabijeKogel(): controleer of kogel uit kogel-hashtable in de buurt is.
*
* v0.1 (31-10-2002)
*/
   public Kogel meestNabijeKogel(long nu) {
      Kogel   kogel, nabijeKogel = null;
      double  afstand;

// lus over alle kogels in hashtable; indien (te) dichtbij, dan kogel verwijderen uit tabel:
      Enumeration k = kogels.elements();

      while (k.hasMoreElements()) {
// bepaal positie kogel t.o.v. eigen bot
         kogel   = (Kogel)k.nextElement();
         afstand = kogel.getAfstand(nu);

         if (afstand <= 35) {
            if ( nabijeKogel == null || afstand < nabijeKogel.getAfstand(nu) ) nabijeKogel = kogel; // selecteer dichtstbijzijnde kogel
            kogels.remove(kogel.naam);
         }
      }
      return nabijeKogel;
   }

/**
* ontwijkKogel(): Kogel ontwijken door loodrecht op de richting tot mijn doel te bewegen.
*
* v0.1 (05-09-2002)
*/
   public void ontwijkKogel() { // kogel in de buurt: uitwijken!
      long nu         = mijnBot.getTime();
      volgendeStap    = nu + inkomendeKogel.getAfstand(nu)/(inkomendeKogel.v*1.2);
      if ( Math.random() > 0.66 ) bewegingsrichtingOmkeren();
      calcLoopafstand = standaardLoopafstand;
      calcDraaicirkel = Utils.normaliseBearing(inkomendeKogel.richting - mijnBot.getHeadingRadians() + Math.PI/2D);
      inkomendeKogel.resetKogel();
if (mijnBot.debugMode > 1) mijnBot.out.println("ontwijkKogel(): ik moet uitwijken!");
   }

   public void bewegingsrichtingOmkeren() {
      if (voorwaards == 1) voorwaards = 0; // vooruit
      else                 voorwaards = 1; // achteruit
   }

   public void omdraaien(double draaihoek) {
      mijnBot.setTurnRightRadians( draaihoek );
   }

   public void setBewegingsparameters( double draaihoek, double afstand ) {
      mijnBot.setAhead( (1D-2D*voorwaards)*afstand );
      mijnBot.setTurnRightRadians( Utils.normaliseBearing(draaihoek) );
   }

}
