package dks;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
import java.util.Vector;

/**
 * MicroDanMK2 - a robot by Dan Skelton
 */
public class MicroDanMK2 extends AdvancedRobot
{
	static double eEnergy = 0;
	public void run() {
		setColors(Color.white, Color.black, Color.black);
		setAdjustGunForRobotTurn(true);
		do {
			//spin the radar, if nothing else
			turnRadarRight(360);
		} while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//^^^^^^^^^^
		//Keep the Gun in their General Direction
		//VVVVVVVVVV
		turnGunRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getGunHeadingRadians()));
		if (getGunHeat() == 0) {
			if (e.getEnergy() <= 16 {
				setFire();
		}		
		//^^^^^^^^^^
		//Driving The Tank
		//VVVVVVVVVV
		if (Math.random() > 0.9 || getDistanceRemaining() == 0) {
			if (e.getDistance() > (300 + (Math.random() * 70))) {
				setTurnRight(e.getBearing() + (Math.random() * 150));
				setAhead(e.getDistance() - 150 + (Math.random() * 80));
			}
			if (e.getDistance() < (200 + (Math.random() * 70))) {
				setTurnRight(e.getBearing() + (Math.random() * 100));
				setBack(90 - (Math.random() * 80));
			}
			if (e.getDistance() < (300 + (Math.random() * 70)) && e.getDistance() > (250 + (Math.random() * 70))) {
				setTurnRight(90 - e.getBearing() + (Math.random() * 100));
				if (getDistanceRemaining() == 0) {
					if (Math.random() > 0.5) {
						setAhead(100 + (Math.random() * 150));
					}
					else {
						setBack(100 + (Math.random() * 150));
					}
				}
			}
		}
		//^^^^^^^^^^
		//Make sure I dont hit Walls
		//VVVVVVVVVV
		if (getX() > (getBattleFieldWidth() - 150)) {
			setTurnRight(270 - (getHeading() + Math.random() * 10));
			setAhead(100 + (Math.random() * 50));
		}
		if (getX() < 150) {
			setTurnRight(90 - (getHeading() + Math.random() * 10));
			setAhead(100 + (Math.random() * 50));
		}
		if (getY() > (getBattleFieldHeight() - 150)) {
			setTurnRight(180 - (getHeading() + Math.random() * 10));
			setAhead(100 + (Math.random() * 50));
		}
		if (getY() < 150) {
			setTurnRight(360 - (getHeading() + Math.random() * 10));
			setAhead(100 + (Math.random() * 50));
		}
		//^^^^^^^^
		//Change direction if they fired
		//VVVVVVVV
		if (e.getEnergy() <= (eEnergy - 0.1) &&  e.getEnergy() >= (eEnergy - 3.0)) {
			//out.println("Enemy Fired!");
			setTurnRight(90 - (e.getHeading() * (Math.random() * 50)));
			if (Math.random() > 0.5) {
				setAhead(100 + (Math.random() * 150));
			}
			else {
				setBack(100 + (Math.random() * 150));
			}
		}
		eEnergy = e.getEnergy();
		execute();
	}
}