package bvh.fry;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Enumeration;
import robocode.util.Utils;

public class Hildisvin implements Constanten {
   public static boolean targettingChallenge;
   public static RoundRectangle2D bewegingsveld;
   public Freya bot;
   public int aantalBotsingenMetWand;
   public double xMax;
   public double yMax;
   public Point2D.Double vorigePositie;
   public Point2D.Double bestemming;
   public Point2D.Double centrum;
   private double positieAfstotingsFactor;

   public Hildisvin(Freya bot, double xMax, double yMax) {
      this.bot = bot;
      this.xMax = xMax;
      this.yMax = yMax;
      this.centrum = new Point2D.Double(0.5 * xMax, 0.5 * yMax);
      this.bewegingsveld = new RoundRectangle2D.Double(WANDAFSTAND, WANDAFSTAND, xMax - 2D * WANDAFSTAND,
            yMax - 2D * WANDAFSTAND, RONDING, RONDING);
   } 
   /**
    * De navigatie is gebaseerd op een anti-gravity/ minimum risk benadering (n.b. deze werd
    * door mij oorspronkelijk maximale entropie/bewegingsvrijheid methode genoemd).
    * Zie Robowiki:
    * http://robowiki.net/cgi-bin/robowiki?MinimumRiskMovement
    * http://robowiki.net/cgi-bin/robowiki?HawkOnFire
    * http://robowiki.net/cgi-bin/robowiki?Coriantumr
    *
    * De robot beweegt loodrecht op de richting naar de geselecteerde tegenstander, waarbij voor
    * een aantal afstanden en random richtingen in wordt bepaald wat het
    * risico is om naar deze positie te gaan. De positie met het laagste risico wordt gekozen.
    */
   public void uitvoeren(Point2D.Double positie) {
      if (!targettingChallenge) {
         bot.log("navigatie():");

         if (bestemming == null) {
            bestemming = vorigePositie = positie;
         } 

         Point2D.Double testPositie;
         double afstotingvorigePositie;
         double pogingen = 0;
         // opslaan van waarde om te voorkomen dat getXX()-methods te vaak worden aangeroepen.
         int others = bot.getOthers();
         
         positieAfstotingsFactor = others > 1 ? 2D*POSITIEAFSTOTINGSFACTOR: POSITIEAFSTOTINGSFACTOR;

         boolean kiesNieuweBestemming = others > 1 ? positie.distance(bestemming) < 2.0 * BOTGROOTTE : true;

         if (kiesNieuweBestemming) {
            // in melee vaker laatste positie afstoten: afhankelijk gemaakt van aantal
            // tegenstanders; hoe meer tegenstanders, hoe meer vooruit blijven lopen.
            afstotingvorigePositie = (Math.random() * others) > 0.60 ? 0 : 1;

            double risicoBestemming = 9999;
            if (!bestemming.equals(positie)) {
               risicoBestemming = weeg(bestemming, afstotingvorigePositie);
            }
            double risicoTestPositie;

            do {
               double testHoek;
               double testAfstand;
               testHoek = TWEEPI * Math.random();
               testAfstand = (others > 1 && others < 4 ? 1.0 : 0.5) * Math.min(positie.distance(bot.kanon.doel),
                     3D * BOTGROOTTE + Math.random() * 6D * BOTGROOTTE);

               testPositie = BotUtils.projecteerPositie(positie, testHoek, testAfstand);

               if (bewegingsveld.contains(testPositie)) {
                  risicoTestPositie = weeg(testPositie, afstotingvorigePositie);

                  if (risicoTestPositie < risicoBestemming) {
                     bestemming = testPositie;
                     risicoBestemming = risicoTestPositie;
                  }
               }
            } while (pogingen++ < 400);

            vorigePositie = positie;
         }

         // controleer of draaihoek gelijk is aan minimale draaihoek:
         double hoek = Utils.normalRelativeAngle(BotUtils.bepaalRichting(positie, bestemming) - bot.getHeadingRadians());
         double draaiHoek = Math.atan(Math.tan(hoek));

         // draai en verplaats robot:
         bot.setTurnRightRadians(draaiHoek);
         bot.setAhead(positie.distance(bestemming) * (hoek == draaiHoek ? 1 : -1));

         // eventueel snelheid minderen om sneller te kunnen draaien:
         if (Math.abs(bot.getTurnRemainingRadians()) > KWARTPI) {
            bot.setMaxVelocity(Math.abs(90D - Math.abs(bot.getTurnRemaining())) / 7.5D);
         } else {
            bot.setMaxVelocity(MAXIMUM_SNELHEID);
         }
      }
   }

   /**
    * Deze functie bepaalt het risico van de opgegeven positie. Bij de bepaling van het
    * risico worden de volgende afwegingen meegenomen:
    * <ul>
    * <li>afstand tot de huidige positie (verder weg is ongunstiger)</li>
    * <li>de verhouding van de eigen energie tot die van de tegenstander (lager is gunstiger)</li>
    * <li>de hoek van de positie t.ov. de eigen positie en die van de tegenstander (de ontsnappingsrichting)</li>
    * <li>afstand tot de positie van de tegenstander (verder weg is gunstiger)</li>
    * <li>de verhouding van de gemiddelde vuurkracht van de tegenstander t.o.v. mijn gemiddelde vuurkracht naar de tegenstander (lager is gunstiger)</li>
    * <li>TO DO: de verhouding van de gemiddelde raakkans van de tegenstander t.o.v. mijn gemiddelde raakkans op de tegenstander (lager is gunstiger)</li>
    * </ul>
    * n.b. scoreBalans o.b.v. treffers*kogelkracht werkt beter dan o.b.v. alleen treffers.
    *
    * @param p de positie waarvoo het risico moet worden bepaald
    * @param afstoting een parameter die aangeeft of de huidige positie moet worden afgestoten.
    *
    * @return het risico van de opgegeven positie
    */
   public double weeg(Point2D.Double p, double afstoting) {
      //      bot.log("weeg(): -----------------------------------------------");
      // afstoting vorige positie: hoe groter de afstand, hoe minder het gewicht (lineaire afname obv afstand).
      double gewicht = positieAfstotingsFactor * afstoting / p.distanceSq(vorigePositie);
      double energie = bot.getEnergy();
      int others = bot.getOthers();

      // afstoting van de hoeken.
      double energieBalans = Math.min(100D / energie, 2);
      gewicht += energieBalans / (HOEKAFSTOTINGSFACTOR * p.distanceSq(0, 0));
      gewicht += energieBalans / (HOEKAFSTOTINGSFACTOR * p.distanceSq(xMax, 0));
      gewicht += energieBalans / (HOEKAFSTOTINGSFACTOR * p.distanceSq(0, yMax));
      gewicht += energieBalans / (HOEKAFSTOTINGSFACTOR * p.distanceSq(xMax, yMax));

      // afstoting/aantrekking van centrum, afhankelijk van fase/type van gevecht. 
      // Bij een 1-vs-1 moet Freya tot centrum worden aangetrokken omdat ze hier 
      // vrij kan bewegen.
      double cfg = (CENTRUMAFSTOTINGSFACTOR * Math.pow(p.distance(centrum), 3D));

      if ( others == 1 || others >= 4) {
         // bij n of meer dan drie tegenstanders het midden opzoeken
         energieBalans *= -1D;

         // hoe groter de afstand, hoe groter de aantrekking
         cfg = (750D * 750D - p.distanceSq(centrum));
      }

      gewicht += energieBalans / cfg;

      // afstoting tegenstanders
      for (Enumeration enm = bot.opponenten.elements(); enm.hasMoreElements();) {
         Doel d = (Doel) enm.nextElement();

         if (d.actief) {
            Point2D.Double doelPositie = d.schatPositie(bot.getTime());
            double afstandBalans = 1D / p.distanceSq(doelPositie);
            energieBalans = BotUtils.maxMin(d.energie / energie, 0.5D, 2D);

            // n.b. scoreBalans o.b.v. treffers*kogelkracht werkt beter dan o.b.v. alleen treffers.
            double scoreBalans = BotUtils.maxMin((d.treffers * d.gemKogelkracht) / (d.treffersFreya * d.gemKogelkrachtFreya),
                  0.5D, 2D);

            // alleen loodrecht op nabije tegenstanders bewegen:
            double hoekBalans = 1D;
            double a = p.distance(bot.positie);
            double b = d.distance(bot.positie);
            double c = p.distance(d);
            hoekBalans = Math.abs(Utils.normalRelativeAngle(Math.acos((a*a+b*b-c*c)/(2*a*b))-HALFPI));
            double nabijheidsBalans = 1D;// / aantalNabijeTegenstanders;
            
            //
            // slimmigheidje naar voorbeeld van Coriantumr: tel het aantal tegenstanders 
            // dat dichter bij deze tegenstander ligt dan het voorgestelde punt. Dit reduceert
            // de kans dat Freya wordt gekozen als doel door n van deze tegenstanders:
/*            
               int aantalNabijeTegenstanders = 1; // namelijk Freya ;)
               for (Enumeration enum2 = bot.opponenten.elements(); enum2.hasMoreElements();) {
                  Doel o = (Doel) enum2.nextElement();
                  if (o.actief && d != o && d.distance(p) >= d.distance(o)) {
                     aantalNabijeTegenstanders++;
                  }
               }
*/             
            double botsingsRisico = 1D;
            if (new Line2D.Double(bot.positie, p).intersectsLine(d.getX(), d.getY(), doelPositie.getX(), doelPositie.getY())) {
               botsingsRisico = 2D;
            }

            // en alle risico factoren optellen:
            double risico = (BOTSINGSFACTOR * botsingsRisico * NABIJHEIDSFACTOR * nabijheidsBalans * SCOREWEEGFACTOR * scoreBalans * ENERGIEWEEGFACTOR * energieBalans 
            * HOEKWEEGFACTOR * (1D+hoekBalans)) * AFSTANDWEEGFACTOR * afstandBalans;
            gewicht += risico;
         }
      }

      return gewicht;
   }

}