package davidalves.net.math;

/**
 * @author David Alves
 *
 */
public interface MovingAverageInterface {
	//Get the current value
	double getAverage();
	
	//Add a value using the default weighting of 1.0
	void addValue(double value);
	
	//Add a value with an explicit weighting
	void addWeightedValue(double value, double weight);
	
	//Returns the number of values currently in the average
	double getSize();
	
	//Clear the moving average
	void clear();
}
