package djc;
import robocode.*;

/**
 * CircularAvgVelTargetingStrategy. 
 */
public class CircularAvgVelTargetingStrategy extends CircularTargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */

    CircularAvgVelTargetingStrategy(Target pT)
    {
        super(pT);
        name = TargetingStrategyManager.CIRCULAR_AVG_VEL;
    }

    /**
     * predictCoordinates
     *  @return Coordinate
     */
    public Coordinate predictCoordinate(double curTime, double futureTime)
    {
        return _predictCoordinate(curTime, futureTime, t.avgVelocity,
				  t.avgAngVelocity, t.heading_rad);
    }
}
