package trab;
import robocode.*;
import java.awt.Color;

import trab.crusader.*;
import trab.utils.*;
import trab.intel.*;

public class Crusader extends AdvancedRobot
{
  static CrusaderWheels wheels;
  static CrusaderGun gun = null;
  static IntelligenceManager intelManager;
  
  int timeSinceScan = 999;
  double enemyEnergy = 100;	
	
	double timeAtRoundStart;
  
  
	double ticks = 0;
	double skipped = 0;
	
	static int round = 0;
	
	public void run()
	{
    round++;
    ticks = 0;
    out.println( "Starting round: " + round );
    
    if ( intelManager == null )
      intelManager = new IntelligenceManager( this, 10 );
    intelManager.initRound();
    
    
    if ( gun == null ) {
      gun = new CrusaderGun( this );
    }
	  gun.roundInit();
	  
	  timeAtRoundStart = System.currentTimeMillis();
	  
	  if ( wheels == null )
	    wheels = new CrusaderWheels( this, intelManager );
    wheels.roundInit();
    
    
    setAdjustRadarForGunTurn( true );
	  setAdjustGunForRobotTurn( true );
    setColors( Color.gray, Color.orange, Color.orange ); // new Color( 1.0f, 0.2f, 0.2f )
    
    while( true )
		{
      ticks++;
      
      if ( timeSinceScan < 999 ) { // to prevent null pointers before we have scanned enemy
        wheels.run();
        /*
        if ( getOthers() > 0 )
          gun.run();*/
      }
      
      
      if ( timeSinceScan++ > 1 )
      {
		    setTurnRadarRightRadians( Double.POSITIVE_INFINITY ); 
	    }
	    execute();
		}
	}


	public void onScannedRobot( ScannedRobotEvent e )
	{
    timeSinceScan = 0;
    setTurnRadarRightRadians( Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians()) * 2);
    
    intelManager.addData( e );
    gun.onScannedRobot( e );
    //wheels.onScannedRobot();
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
    //out.println( intelManager.getRound() + " : " + getTime() + ". BP= " + e.getPower() + " dist= " + intelManager.getRobotDistanceToEnemy(0) );
    
    intelManager.addData( e );
    //wheels.onHitByBullet( e );  
    
	}
	public void onBulletHit(BulletHitEvent e)
	{
	  /*
	  wheels.onBulletHit( e );  
	  */
	  intelManager.addData( e );
	  
	  //gun.onBulletHit( e );  
  }
  public void onBulletHitBullet(BulletHitBulletEvent e)
  {
    //
  }
  public void onDeath(DeathEvent e)	{
		//if ( intelManager.getRound() == getNumRounds() )
		out.println( "Skipped this round = " +skipped/ticks*100 + " % " );
		out.println( "Fps: "  + (int) ( ticks*1000 / (System.currentTimeMillis()-timeAtRoundStart) ) );
		/*
		wheels.onDeath( e );
	  if ( intelManager.getRound() == getNumRounds() )
	    wheels.printStats();*/
	}
	public void onWin(WinEvent e)	{
		
		//if ( intelManager.getRound() == getNumRounds() )
		out.println( "Skipped this round = " + skipped/ticks*100 + " % " );
		out.println( "Fps: "  + (int) ( ticks*1000 / (System.currentTimeMillis()-timeAtRoundStart) ) );
		//wheels.onWin( e );
	}
	public void onHitWall(HitWallEvent e)
	{
		//out.println("--- HIT WALL ---");
	}
	public void onSkippedTurn( SkippedTurnEvent e )
	{
    skipped++;
    //out.println( "--- SKIPPED TURN ---" );
  }
}