package maribo;
import robocode.*;
import java.awt.Color;
import robocode.util.*;
import java.awt.geom.*;

/**
 * IotaCT - a robot by Alexander MacKenzie
 */
public class IotaCT extends AdvancedRobot
{
		String trackName;
		int count = 0;
		int side;
		double oldEnemyHeading;
		
	
	public void run() {
		
		side = (Math.random() < 0.5 ? 1 : -1);
		double mvAmt = (Math.max(getBattleFieldWidth(),getBattleFieldHeight())/3)*side;
		
		/*
		setBodyColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setGunColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setRadarColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setBulletColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setScanColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		*/
		
		setColors(Color.gray,Color.black,Color.green,Color.black,Color.green);
		
		trackName = null;
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		turnLeft(getHeading());
		ahead(getBattleFieldHeight()/2 - getY());
		turnRight(90);
		ahead(getBattleFieldWidth()/2 - getX());
		turnRight((Math.random()-.5)*180);
			
		// Robot main loop
		while(true) {	
			ahead(mvAmt);
			turnRight(45);
			back(mvAmt);
			turnRight(45);
			setTurnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		count++;
		if (count > (getOthers()*2)+1) {
			trackName = null;
		}
		
		if (trackName != null && !e.getName().equals(trackName)) {
			if (e.getDistance() < 100) {
				trackName = e.getName();
			} else {
				return;
			}
		}
		if (trackName == null) {
			trackName = e.getName();
		}		
		count = 0;
		
		double firePower = Math.min(2.4,Math.min(600/e.getDistance(),getEnergy()/8));
		double myX = getX(),
			   myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = myX + e.getDistance() * Math.sin(absoluteBearing),
			   enemyY = myY + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = e.getVelocity();
		oldEnemyHeading = enemyHeading;
	 
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(),
		       battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * firePower) < 
		      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 36.0
				|| predictedY > battleFieldHeight - 36.0){
		 
				predictedX = Math.min(Math.max(18.0, predictedX), 
				    battleFieldWidth - 36.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 
				    battleFieldHeight - 36.0);
				break;
			}
		}
		double radarTurn = 1.9*Utils.normalRelativeAngle(
		    		absoluteBearing - getRadarHeadingRadians());
		double theta = Utils.normalAbsoluteAngle(Math.atan2(
		    predictedX - myX, predictedY - myY));
		if (getOthers() >= 3) {
			if (e.getName().equals(trackName) && getGunHeat() < 1) {
				setTurnRadarRightRadians(radarTurn);
			} else {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
		} else {
			setTurnRadarRightRadians(radarTurn);
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(
		    theta - getGunHeadingRadians()));
		if (getGunHeat() == 0) {	
			fire(firePower);
		}
	}

	public void onHitRobot(HitRobotEvent e) {
		trackName = e.getName();
	}
}
