package wiki.nano;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

public class RaikoNano extends AdvancedRobot {
	static double direction = 1, bulletVelocity;
	
	public void run() {
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double v1, v2, offset = 2;
		
		setTurnGunRightRadians(Utils.normalRelativeAngle((v1 = getHeadingRadians() + e.getBearingRadians()) + 
							Math.random() * e.getVelocity() / 13 * Math.sin(e.getHeadingRadians() - v1) - getGunHeadingRadians()));
		
		while(!new Rectangle2D.Double(18,18,764,564).
					contains(getX() + 160 * Math.sin(v2 = v1 + direction * (offset -= .02)), getY() + 160 * Math.cos(v2)));
		
		setFire(Math.min(1100 / (v1 = e.getDistance()), getEnergy()/6));
		if(Math.random() > Math.pow(v1 = 0.5952 * bulletVelocity / v1, v1) || offset < 0.7) {
			direction = -direction;
		}
		
		setAhead(1000 * Math.cos(v2 -= getHeadingRadians()));
		setTurnRightRadians(Math.tan(v2));
		setTurnRadarLeft(getRadarTurnRemaining());
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		bulletVelocity = e.getVelocity();
	}
}
