package jwst.DAD.Movement;

import robocode.*;
import robocode.util.Utils;

/*************************************************************************************************
 * 
 * Movement(Melee): AntiGravity - this uses basic vectors to assign "gravity points" to objects
 * that we want to avoid. This is especially helpful in the melee because by assigning gravity
 * points to, say, the center of the battlefield or setting gravity points to robots we can
 * make sure that we stay clear and away from danger.
 * A class for anti-gravity movement
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * @date June 10th, 2009
 * 
 * Credit: DustBunny
 * Credit:http://www.ibm.com/developerworks/java/library/j-antigrav/
 * 
 *************************************************************************************************/
public class AntiGravity
{
    private static AdvancedRobot robot;

    // use these to keep track of where i should be headed
    // resultant vector forces
    static double xForce;
    static double yForce;

    // keeping track of the last target based on name
    static String lastTargetName;

    // the distance to the last robot that was closest
    static double lastClosestDistance;


    /**
     * Hand it a robot and it makes the tank to run
     * @param robot
     */
    public AntiGravity( AdvancedRobot robot )
    {
        this.robot = robot;
    }

    /**
     * basically this method is only called once to initiate the anti gravity bot and to make it
     * start scanning other enemy robots
     */
    public void run()
    {
        // reset the distance to some obscenely large number that can never be attained
        lastClosestDistance = Double.POSITIVE_INFINITY;

        // turn the radar some obscenely big number
        robot.turnRadarRightRadians( Double.POSITIVE_INFINITY );
    }

    /**
     * whenever a robot is scanned in the field
     * add to your x force and y force and see if it is closest to you
     * if so... target it
     * @param e - ScannedRobotEvent
     */
    public void onScannedRobot( ScannedRobotEvent e )
    {
    	// calculated each time
        double absoluteBearing = e.getBearingRadians() + robot.getHeadingRadians();
        double distance = e.getDistance();

        // for every bot scanned it adds their x and y s comparative to me
        // i want to multiply by 90% of the previous because I just use a running 
        // resultant force that is never cleared
        // thus i want to make stuff that was scanned a long time ago less
        // and less important exponentially
        xForce = xForce * .9 - Math.sin( absoluteBearing ) / distance;
        yForce = yForce * .9 - Math.cos( absoluteBearing ) / distance;
        
        // figure out the angle to turn
        double angle = 
            // i don't want to be stupid so ill limit the angle between -pi and pi
            Utils.normalRelativeAngle( 
                // i like random numbers... just to throw any pattern matching type off
                // it gets it from 0 to 1 so it will be something in the range of
                // 0 to 57.2957795 degrees... just good enough.. plus.. we can only turn a certain amount
                // before we recalculate this.. so it tends to be something fairly insignificant
                Math.random()
                // get the absolute bearing between where i am now and where i want to be headed based
                // upon the x and y forces i calculated
            +   Math.atan2( xForce + 1 / robot.getX() - 
                1 / ( robot.getBattleFieldWidth() - robot.getX() ),
                yForce + 1 / robot.getY() - 
                1 / ( robot.getBattleFieldHeight() - robot.getY() ) ) 
                // subtract where i am currently headed.. very important..
            -   robot.getHeadingRadians() );
        
        // turn now...
        robot.setTurnRightRadians( angle );
        
        // just go ahead it doesn't matter how far cause i want to keep going ahead
        // no strafing 
        robot.setAhead( Double.POSITIVE_INFINITY );

        // i don't want to make a hard turn.. i might run into a wall..
        // on the other hand.. if i don't have to turn much
        // greater than 60 to be exact...
        // also.. i don't want to hit the walls too hard.. I am somewhat prone to that
        // wall smoothing didn't work out too well
        robot.setMaxVelocity( 480 / robot.getTurnRemaining() );

        // calculate the bullet power
        // basically make it LARGE most of the time
        // because most of the time... in a melee there are tons of robots
        // it does not matter if i predict or anything else cause most of the time
        // it will hit a robot
        // HOWEVER if the robot is really far away or we are low on energy... don't waste the energy
        // just set a lower bullet power
        // if the ratio of my energy to the distance the enemy bot is away from me
        // is anything less than 1/10 then i will start to decrement my bullet power from the max
        // possible, 3
        // otherwise, just FIRE AWAY, as hard as possible
        // seeing as the hit percentage is pretty high
        double bulletPower = robot.getEnergy() * 30D / distance;
        
        // check the gun heat, if it's 0 fire away
        if(robot.getGunHeat() == 0)
            robot.setFireBullet(bulletPower);
        
        // make a boolean value seeing if a real bullet has been fired
        // then set if i really did fire that bullet based on the bullet power
        boolean firedbullet = bulletPower != 0;
        
        // if i fired a bullet reset the closest distance cause i might have a new target to fire at
        if ( firedbullet )
            lastClosestDistance = Double.POSITIVE_INFINITY;

        // if i happen to find a closer target.. which i will if i just set to fire a bullet...
        // start turning to fire at him
        if ( lastClosestDistance > distance )
        {
            // set the distance of that bot
            lastClosestDistance = distance;
            // set the name of that bot.. the one distinguishing thing of ALL bots
            lastTargetName = e.getName();
        }

        // if the target equals the name passed on the scanned robot
        // turn to fire at it and make the radar go the other way
        if ( lastTargetName == e.getName() )
        {
            // the radar can turn a maximum of 90 degrees per turn
            // therefore i can merely rotate the radar back in the opposite direction
            // every time it completes a full rotation
            if ( robot.getRadarHeading() < 90 )
            {
                // just set it back the other way infinity degrees
                robot.setTurnRadarLeft( robot.getRadarTurnRemaining() );
            }

            // turn the gun towards the enemy
            // i really don't care if he moves because in melees i still have a high chance
            // of hitting bots even if i miss the one I am aiming at
            // ALSO bots don't tend to move too much in melees due to their locking tendencies
            // of noobly bots... (e.g. parts bot locks into a triangle that doesn't move if there
            // are three...
            robot.setTurnGunRightRadians( Utils.normalRelativeAngle( absoluteBearing
                - robot.getGunHeadingRadians() ) );
        }
    }
}
