package staticline.whiskey.utils;

import java.awt.Color;
import java.awt.Graphics2D;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import staticline.IRobotManager;
import staticline.whiskey.AbstractWhiskeyManager;

public class PaintManager extends AbstractWhiskeyManager implements IRobotManager {
	
	public PaintManager(AdvancedRobot b) {
		super(b);
	}

	public void initialize() {
		//
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		//
	}
	
	public void onPaint(Graphics2D g) {
        /*-------------------- scanned target --------------------*/
        // Set the paint color to a red transparent color
        g.setColor(new Color(0xff, 0x00, 0x00, 0x50));
        // Draw a line from our robot to the scanned robot
        g.drawLine(this.bot.scannedX, this.bot.scannedY, (int)this.bot.getX(), (int)this.bot.getY());
        /*
        // Draw a filled square on top of the scanned robot that covers it
        g.fillRect(scannedX - 20, scannedY - 20, 40, 40);
        */
        /*-------------------- virtual target --------------------*/
        // Set the paint color to a green transparent color
         g.setColor(new Color(0x00, 0xff, 0x00, 0x50));
        // Draw a filled square on top of the scanned robot that covers it
        g.fillRect((int)this.bot.projectedX - 20, (int)this.bot.projectedY - 20, 40, 40);
        // paint intermediate steps
        g.setColor(new Color(0xff, 0x00, 0x00, 0x30));
        if(this.bot.intermediateX != null){
            for(int i=0; i<this.bot.intermediateX.length; ++i){
                g.fillOval(this.bot.intermediateX[i], this.bot.intermediateY[i], 5, 5);
            }
        }
        /*-------------------- movement arcs --------------------*/
        /*
        //forward
    	g.setColor(new Color(0x0, 0xff, 0x00, 0x30));
        g.fill(new Arc2D.Double(this.bot.scannedX-50, this.bot.scannedY-50, 100, 100, Whiskey.forward_right_angle, 90, Arc2D.PIE));
        //back
        g.setColor(new Color(0xff, 0x00, 0x00, 0x30));
        g.fill(new Arc2D.Double(this.bot.scannedX-50, this.bot.scannedY-50, 100, 100, Whiskey.backward_right_angle, 90, Arc2D.PIE));
        //sides
        g.setColor(new Color(0xff, 0xff, 0x30, 0x30));
        g.fill(new Arc2D.Double(this.bot.scannedX-50, this.bot.scannedY-50, 100, 100, Whiskey.forward_left_angle, 90, Arc2D.PIE));
        g.fill(new Arc2D.Double(this.bot.scannedX-50, this.bot.scannedY-50, 100, 100, Whiskey.backward_left_angle, 90, Arc2D.PIE));
        */
        /*-------------------- movement vector --------------------*/
        /*
        g.setColor(new Color(0xff, 0xff, 0xff, 0x50));
        g.setStroke(new BasicStroke(3));
        double theta = this.bot.t_heading_old + Math.PI/2;//FIXME: horizontal -, vertical + //TODO: learn math!
        int x2 = this.bot.scannedX + (int)(this.bot.t_velocity_old * 15 * Math.cos(theta));
        int y2 = this.bot.scannedY + (int)(this.bot.t_velocity_old * 15 * Math.sin(theta));
        //g.drawLine(this.bot.scannedX, this.bot.scannedY, x2, y2);
        */
    }

}
