package bayen.nut;
import robocode.*;
import java.util.*;
import robocode.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.*;
import java.util.zip.*;
class GFTWave1 extends Condition {
	static Point2D targetLocation;

	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;
	boolean realWave;
	int others;
	boolean othersCheck = true;
	public String enemyName;
	int totalOthers;

	private static final double MAX_DISTANCE = 900;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int BINS = 25;
	private static final int MIDDLE_BIN = (BINS - 1) / 2;
	private static final double MAX_ESCAPE_ANGLE = 0.7;
	private static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
	
	private static double weightn = 250 * 5;
	public static GunEnemy[] enemies;
	
	private static double[][][][][][] statBuffers = new double[3][DISTANCE_INDEXES][VELOCITY_INDEXES][5][5][BINS];

	private double[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled = 0;
	private Gun gun;
	private double gunHeating;
	
	GFTWave1(AdvancedRobot _robot, Gun _gun, int others) {
		this.robot = _robot;
		this.gun = _gun;
		this.others = others;
		if(enemies == null)
		enemies = new GunEnemy[others];
	}
	
	public boolean test() {
		if(robot.getOthers() > 1) weightn = 10;
		/*if(distanceTraveled == 0){
		gunHeating = Squirrel.getGunHeat();
		realWave = (gunHeating == 1 + bulletPower / 5);}*/
		advance();
		int i = 0;
		do{
			if(gun.e != null){
				if(enemies[i] == null){
					enemies[i] = new GunEnemy(robot, gun.e);
					enemies[i].restoreFactors();
					break;
				}
				enemies[i].setDefaultRobot(robot);
				if(enemies[i].getName() == gun.e.getName()){
					enemies[i].update(gun.e);
					break;
				}
			}
		}while(++i < others);
		//if(realWave)
		//gun.drawCircle(new Point2D.Double(gunLocation.getX(), gunLocation.getY()), distanceTraveled, Color.blue);
		if (hasArrived()) {
			double newWeight = weightn;
			if(!realWave) newWeight /= 5;
			buffer[currentBin()] = rollingAverage(buffer[currentBin()], 1, weightn);
			missedBins();
			robot.removeCustomEvent(this);
		}
		return false;
	}

	double mostVisitedBearingOffset() {
		return (lateralDirection * BIN_WIDTH) * (mostVisitedBin() - MIDDLE_BIN);
	}
	
	void setSegmentations(double distance, double velocity, double lastVelocity, long lastTimeStill, double heading, double relativeHeading) {
		if(othersCheck){
			totalOthers = robot.getOthers();
			othersCheck = false;
		}
		int meleeIndex = (totalOthers > 1?(robot.getOthers()>1?2:1):0);
		int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
		int velocityIndex = (int)Math.abs(velocity / 2);
		int lastVelocityIndex = (int)Math.abs(lastVelocity / 2);
		int timeSinceStillIndex = (int)Math.abs(Math.min((robot.getTime() - lastTimeStill) / 4,4));
		if(timeSinceStillIndex > 4) timeSinceStillIndex = 4;
		int headingIndex = (int)(heading / (72));
		if(headingIndex > 4) headingIndex = 4;
		int relativeHeadingIndex = (int)(relativeHeading / (72));
		if(relativeHeadingIndex > 4) relativeHeadingIndex = 4;
		int i = 0;
		int ene = 0;
		do{
			if(gun.e != null){
				if(enemies[i] == null){
					enemies[i] = new GunEnemy(robot, gun.e);
					enemies[i].restoreFactors();
					break;
				}
				enemies[i].setDefaultRobot(robot);
				if(enemies[i].getName() == gun.e.getName()){
					ene = i;
					break;
				}
			}
		}while(++i < others);
		if(enemies[ene] != null)
		buffer = enemies[ene].aimFactors[meleeIndex][distanceIndex][velocityIndex][timeSinceStillIndex][relativeHeadingIndex];
		else
		buffer = statBuffers[meleeIndex][distanceIndex][velocityIndex][timeSinceStillIndex][relativeHeadingIndex];
	}

	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}

	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation) - 18;
	}
	
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * BIN_WIDTH)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
	private void missedBins() {
		int hitBin = currentBin();
		for (int i = 0; i < BINS; i++) {
			if (i != hitBin) {
				buffer[i] = rollingAverage(buffer[i], 0, weightn);
			}
		}
	}

	public int getMostVisitedInt() {
		return mostVisitedBin();
	}
	
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
	public double rollingAverage(double oldVal, double newVal, double weight) {
		return ((weight - 1.0) * oldVal + newVal) / weight;
	}
	void restoreFactors(String enemyName) {
        try {
            ZipInputStream zipin = new ZipInputStream(new
                FileInputStream(robot.getDataFile(enemyName + "_GFfile.zip")));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            statBuffers = (double[][][][][][])in.readObject();
            in.close();
        }
        catch (IOException e) {
            System.out.println("Ah! A new aquaintance. I'll be watching you " + enemyName + ".");
            statBuffers = new double[3][DISTANCE_INDEXES][VELOCITY_INDEXES][5][5][BINS];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    void saveFactors(String enemyName) {
        try {
            ZipOutputStream zipout = new ZipOutputStream(new RobocodeFileOutputStream(robot.getDataFile(enemyName + "_GFfile.zip")));
            zipout.putNextEntry(new ZipEntry(enemyName));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(statBuffers);
            out.flush();
            zipout.closeEntry();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error saving factors:" + e);
        }
int i = 0;
		do{
			if(gun.e != null){
				if(enemies[i] == null){
					break;
				}
				enemies[i].setDefaultRobot(robot);
				enemies[i].saveFactors();
			}
		}while(++i < others);
    }
}

												