// (C) 2007 Kim, Taegyoon
// AGF: anti-guess-factor

package stelo;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's
import java.lang.*;         // for Double and Integer objects
import java.util.ArrayList; // for collection of waves
import java.awt.Color;

public class MatchupAGF extends AdvancedRobot {
    public static int BINS = 47;
    public static double _surfStats[] = new double[BINS]; // we'll use 47 bins
    public Point2D.Double _myLocation;     // our bot's location
    public Point2D.Double _enemyLocation;  // enemy bot's location

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
	private static final double BULLET_POWER = 1.9;
	
	private static double lateralDirection;
//	private static double lastEnemyVelocity;
	
	private static double lateralMyDirection;
	private static double lastMyVelocity;
	private static double lastEnemyBulletPower = 0.1;
	private static double mostVisitedAngle = 0;
	
    // We must keep track of the enemy's energy level to detect EnergyDrop,
    // indicating a bullet is fired
    public static double _oppEnergy = 100.0;

    // This is a rectangle that represents an 800x600 battle field,
    // used for a simple, iterative WallSmoothing method (by Kawigi).
    // If you're not familiar with WallSmoothing, the wall stick indicates
    // the amount of space we try to always have on either end of the tank
    // (extending straight out the front or back) before touching a wall.
    public static Rectangle2D.Double _fieldRect
        = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 160;

//
	private static final int NUM_LOGS = 2; // [0]: velocity, [1]: angleChange, [2]: distance, [3]: bearingChange, [4]: ticksSinceMyFire
	private static final int PATTERN_LENGTH = 9000;
	private static int searchLength = 32; // increasing this will slow down the game
	private static int pattern_size = 0;
	
	private static int bulletTravelTime = 0;
	private static double[][] theLog = new double[PATTERN_LENGTH][NUM_LOGS];
	
	private static int cursor = 0;
	
	private static double lastEnemyHeading = 0;
	private static double lastEnemyVelocity = 0;
	private static double lastEnemyBearing = 0;
	private static double lastEnemyEnergy;
		
	private static int ticksSinceMyFire = 0;
	private static double smallestDiff;
	private static double enemyBulletPower = 0.1;
	private static double energyDrop = 0;
	private static int ticksSinceDirection = 0;	
	
    public void run() {
		setColors(null, Color.BLACK, Color.YELLOW);
		lateralDirection = 1;
		lastEnemyVelocity = 0;
		
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            _surfStats[x] += 1.0 / (Math.pow(((double) BINS + 1.0) / 2.0 - x, 2) + 1);
        }

        do {
            // basic mini-radar code
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        _myLocation = new Point2D.Double(getX(), getY());

        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + getHeadingRadians();

        setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);

/*
        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));


        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09
            && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick

            _enemyWaves.add(ew);
        }

        _oppEnergy = e.getEnergy();
*/
        // update after EnemyWave detection, because that needs the previous
        // enemy location as the source of the wave
        _enemyLocation = project(_myLocation, absBearing, e.getDistance());

//        updateWaves();
//        doSurfing();

// aim

		if (getGunHeat() / getGunCoolingRate() < 3) do {
	
			double eX = e.getDistance() * Math.sin(absBearing);
			double eY = e.getDistance() * Math.cos(absBearing);
			
//			if (e.getEnergy() == 0.0) {
//				maxVelocity = 8.0;
//				goTo(new Point2D.Double(getX() + eX, getY() + eY));
//				return;
//			}
	
			double db = 0;
			//double ww = e.getHeadingRadians();
	
			int index;
			//indexVelocity = bestIndex(velocityChange);
			//indexAngle = bestIndex(angleChange);
			//indexVelocity = indexAngle = bestIndex(velocityChange, angleChange);
			index = bestIndex(theLog);

			double bulletPower;
			energyDrop = lastEnemyEnergy - e.getEnergy();
			if (energyDrop >= 0.1 && energyDrop <= 3) 
				enemyBulletPower = energyDrop;
			bulletPower = enemyBulletPower;
				
			//bulletPower = limit(0.1, bulletPower, (enemyDistance < 100 || getOthers() > 5 || smallestDiff < 1) ? 3.0 : 2.0);
			//if (smallestDiff == 0) bulletPower = 3;
			if (e.getDistance() < 100) bulletPower = 3; // anti-rambot
			bulletPower = Math.min(bulletPower, e.getEnergy() / 5.0 );
			bulletPower = limit(0.1, bulletPower, 3.0);
									
			if (getGunHeat() == 0) {
				out.println("matched index: " + index + "\tdiff: " + smallestDiff + "\tsearchLength: " + searchLength);
				ticksSinceMyFire = 0;
			}
			
			//indexVelocity = (int) (Math.random() * (pattern_size - 1));
			//indexAngle = indexVelocity;
						
			double ww = e.getHeadingRadians();
			double v = e.getVelocity();
	
			//searchLength = 0;
			if (v * lastEnemyVelocity <= 0) {
				searchLength = (int) limit(32, ticksSinceDirection + 10, 128);
				ticksSinceDirection = 0;
			}
			ticksSinceDirection++;
			
			bulletTravelTime = 0;
			do {
				// db+=11; //11 is the velocity of a fire(3) bullet.
				db += (20.0 - 3.0 * bulletPower);
				// ww+=w; // turn w radians for next step
	
				eX += v * Math.sin(ww);
				eY += v * Math.cos(ww);
	
				ww += theLog[index][1];
				//ww = theLog[index][1];
				//v = limit(-8.0, v + velocityChange[indexVelocity], 8.0);
				v = theLog[index][0];
				
				if (index + 1 != cursor) {
					index = (index + 1) % PATTERN_LENGTH;
				}
				
				//searchLength += 1;
				bulletTravelTime++;
			} while (db < Point2D.distance(0, 0, eX, eY)); // The bullet travelled
															// far enough to hit our
															// target!
			//out.println("searchLength: " + searchLength);
			setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY)
					- getGunHeadingRadians())));
			
			if (getEnergy() > bulletPower)
				setFire(bulletPower);
		} while (false);
		else {
			setTurnGunRightRadians(Utils.normalRelativeAngle( absBearing - getGunHeadingRadians() ) );
		}
		ticksSinceMyFire++;
		
		//out.println("cursor: " + cursor);
		{
			theLog[cursor][0] = e.getVelocity();
			theLog[cursor][1] = e.getHeadingRadians() - lastEnemyHeading;
			//theLog[cursor][1] = e.getHeadingRadians();
			//theLog[cursor][2] = e.getDistance() / 10000;
			//theLog[cursor][3] = (absBearing - lastEnemyBearing) / 100;
			//theLog[cursor][4] = ticksSinceMyFire / 100;
			
			cursor = (cursor + 1) % PATTERN_LENGTH;
			if (pattern_size < PATTERN_LENGTH)
				pattern_size++;
		}
		lastEnemyHeading = e.getHeadingRadians();
		lastEnemyVelocity = e.getVelocity();
		lastEnemyBearing = absBearing;
		lastEnemyEnergy = e.getEnergy();			
	
//
		double enemyDistance = e.getDistance();
		double enemyVelocity = e.getVelocity();
		if (getVelocity() != 0) {
			lateralMyDirection = GFTUtils.sign(getVelocity() * Math.sin(getHeadingRadians() - absBearing - Math.PI));
		}
	
		{	
			GFTWave2 wave2 = new GFTWave2(this);
			wave2.gunLocation = GFTUtils.project(_myLocation, absBearing, enemyDistance);
			GFTWave2.targetLocation = new Point2D.Double(getX(), getY());
			
			wave2.lateralDirection = lateralMyDirection;
			wave2.bulletPower = lastEnemyBulletPower;
			wave2.setSegmentations(enemyDistance, getVelocity(), lastMyVelocity);
			lastMyVelocity = getVelocity();
			wave2.bearing = absBearing + Math.PI;
			
			mostVisitedAngle = absBearing + Math.PI + wave2.mostVisitedBearingOffset();
			//out.println(mostVisitedAngle);
			//setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + wave.mostVisitedBearingOffset()));
			//setFire(wave.bulletPower);
			if (e.getEnergy() >= BULLET_POWER) {
				addCustomEvent(wave2);
			}
								
		}
	
 	    _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(mostVisitedAngle));
	
		double bulletPower = _oppEnergy - e.getEnergy();	
        if (bulletPower < 3.01 && bulletPower > 0.09 && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick

            _enemyWaves.add(ew);

			lastEnemyBulletPower = bulletPower;
        }				
        _oppEnergy = e.getEnergy();
/*
		// anti-head-on
 	    _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));
	
        if (bulletPower < 3.01 && bulletPower > 0.09 && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick

            _enemyWaves.add(ew);
        }		
*/	
        updateWaves();
        doSurfing();

		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);
    }

	private int bestIndex(double[][] series) {
		smallestDiff = Double.POSITIVE_INFINITY;

		int result = 0;

		int count = 0, i = (PATTERN_LENGTH + cursor - 1) % PATTERN_LENGTH;
		while (count < PATTERN_LENGTH) {
			double diff = 0;
			for (int j = 0; j < searchLength; j++) {
				int k = (i + j) % PATTERN_LENGTH;
				int searchIndex = (PATTERN_LENGTH + cursor - searchLength + j) % PATTERN_LENGTH;
				if (k == searchIndex) {
					diff = Double.POSITIVE_INFINITY;
					break;
				}
				for (int logClass = 0; logClass < NUM_LOGS; logClass++) {
					diff += Math.abs(series[searchIndex][logClass] - series[k][logClass]);
				}
			}
			if (diff < smallestDiff && Math.abs((i + searchLength) % PATTERN_LENGTH - cursor) > bulletTravelTime) {
			//if (diff == 0) {
				smallestDiff = diff;
				result = (i + searchLength) % PATTERN_LENGTH;
			}
			count++;
			i = (PATTERN_LENGTH + i - 1) % PATTERN_LENGTH;
				
		}
		//out.println("Diff: " + smallestDiff);
		return result;
	}				

	public void onPaint(java.awt.Graphics2D g) {
		g.draw3DRect((int) getX() - 32, (int) getY() - 32, 72, 72, true);
				
        EnemyWave surfWave = null;

        for (int x = 0; _enemyWaves != null && x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

			double eX = ew.fireLocation.getX() + ew.distanceTraveled * Math.sin(ew.directAngle);
			double eY = ew.fireLocation.getY() + ew.distanceTraveled * Math.cos(ew.directAngle);

			g.draw3DRect((int) eX, (int) eY, 15, 15, true);
        }		
		
	}			

    public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
                _enemyWaves.remove(x);
                x--;
            }
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, update our stat array to reflect the danger in that area.
    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            _surfStats[x] += 1.0 / (Math.pow(index - x, 2) + 1);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation);

                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }


    // CREDIT: mini sized predictor from Apollon, by rozu
    // http://robowiki.net?Apollon
    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
    	Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
    	double predictedVelocity = getVelocity();
    	double predictedHeading = getHeadingRadians();
    	double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

    	do {
    		moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
    		moveDir = 1;

    		if(Math.cos(moveAngle) < 0) {
    			moveAngle += Math.PI;
    			moveDir = -1;
    		}

    		moveAngle = Utils.normalRelativeAngle(moveAngle);

    		// maxTurning is built in like this, you can't turn more then this in one tick
    		maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
    		predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

    		// this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
    		// otherwise you want to accelerate (look at the factor "2")
    		predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
    		predictedVelocity = limit(-8, predictedVelocity, 8);

    		// calculate the new predicted position
    		predictedPosition = project(predictedPosition, predictedHeading, predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
    	} while(!intercepted && counter < 500);

    	return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));

        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = getClosestSurfableWave();

        if (surfWave == null) { return; }

        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);

        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2), -1);
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2), 1);
        }

        setBackAsFront(this, goAngle);
    }

    // This can be defined as an inner class if you want.
    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;

        public EnemyWave() { }
    }

    // CREDIT: Iterative WallSmoothing by Kawigi
    //   - return absolute angle to move at after account for WallSmoothing
    // robowiki.net?WallSmoothing
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, 160))) {
            angle += orientation*0.05;
        }
        return angle;
    }

    // CREDIT: from CassiusClay, by PEZ
    //   - returns point length away from sourceLocation, at angle
    // robowiki.net?CassiusClay
    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
    //  - returns the absolute angle (in radians) from source to target points
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20D - (3D*power));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }
}

class GFTWave extends Condition {
	static Point2D targetLocation;

	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;

	private static final double MAX_DISTANCE = 900;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int BINS = 25;
	private static final int MIDDLE_BIN = (BINS - 1) / 2;
	private static final double MAX_ESCAPE_ANGLE = 0.7;
	private static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
	
	private static int[][][][] statBuffers = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][VELOCITY_INDEXES][BINS];

	private int[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled;
	
	GFTWave(AdvancedRobot _robot) {
		this.robot = _robot;
	}
	
	public boolean test() {
		advance();
		if (hasArrived()) {
			buffer[currentBin()]++;
			robot.removeCustomEvent(this);
		}
		return false;
	}

	double mostVisitedBearingOffset() {
		return (lateralDirection * BIN_WIDTH) * (mostVisitedBin() - MIDDLE_BIN);
	}
	
	void setSegmentations(double distance, double velocity, double lastVelocity) {
		int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
		int velocityIndex = (int)Math.abs(velocity / 2);
		int lastVelocityIndex = (int)Math.abs(lastVelocity / 2);
		buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
	}

	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}

	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation) - 18;
	}
	
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * BIN_WIDTH)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
	
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
}

class GFTWave2 extends Condition {
	static Point2D targetLocation;

	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;

	private static final double MAX_DISTANCE = 900;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int BINS = 25;
	private static final int MIDDLE_BIN = (BINS - 1) / 2;
	private static final double MAX_ESCAPE_ANGLE = 0.7;
	private static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
	
	private static int[][][][] statBuffers = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][VELOCITY_INDEXES][BINS];

	private int[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled;
	
	GFTWave2(AdvancedRobot _robot) {
		this.robot = _robot;
	}
	
	public boolean test() {
		advance();
		if (hasArrived()) {
			buffer[currentBin()]++;
			robot.removeCustomEvent(this);
		}
		return false;
	}

	double mostVisitedBearingOffset() {
		return (lateralDirection * BIN_WIDTH) * (mostVisitedBin() - MIDDLE_BIN);
	}
	
	void setSegmentations(double distance, double velocity, double lastVelocity) {
		int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
		int velocityIndex = (int)Math.abs(velocity / 2);
		int lastVelocityIndex = (int)Math.abs(lastVelocity / 2);
		buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
	}

	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}

	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation) - 18;
	}
	
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * BIN_WIDTH)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
	
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
}					

class GFTUtils {
	static double bulletVelocity(double power) {
		return 20 - 3 * power;
	}
	
	static Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}

	static int sign(double v) {
		return v < 0 ? -1 : 1;
	}
	
	static int minMax(int v, int min, int max) {
		return Math.max(min, Math.min(max, v));
	}
}																								