package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* Move1on1LRrand4away5.java -- for 1 on 1
*                          _Eړ,~L
*                          
*                          for [
*
* Date:		2002/Nov/16
* 			2003/Jan/03
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class Move1on1LRrand4away5 implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	Random randLen = new Random(System.currentTimeMillis());
	Random randStop = new Random(System.currentTimeMillis());
	Random randSpeed = new Random(System.currentTimeMillis());
	Random randDir = new Random(System.currentTimeMillis());
	FieldMap map;
	
	int dirIndex = 0;
	int dir = 1;
	int stopCount = 0;
	final int D1, D2;			//ړpxˑ鋗
	
	//---------------------------------------------------------
	// constructor
	//
	//
	//---------------------------------------------------------
	public Move1on1LRrand4away5(MyRobot my) {
		this.my = my;
		fW = my.fW;
		fH = my.fH;
		map = my.map;
		D1 = (int)(fW * 0.6);
		D2 = (int)(fW * 0.875);
		init();
	}
	
	public void init() {
		dstX = my.getX();
		dstY = my.getY();
		my.EPSILON = 50;
	}
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		Enemy ene = map.getNearestEnemy(my.getTime());

		if (ene == null) return;
		
		double angle;				//[_[]px
		double absoluteBearing;		//Gʒu̐Ίpx
		double bearing, distance;
		
		bearing = ene.getBearing();
		distance = ene.getDistance();

		absoluteBearing = M.angleUnder180(bearing + my.getHeading());
		
		//Gڋ߁CH
		if (distance < 150) {
			noliMeTangere(absoluteBearing);
			return;
		}
			
			
		
		if (my.isArrived(dstX, dstY)) {
			//stop
			if (stopCount != 0) {
				stopCount++;
				if (stopCount > distance * 0.02) stopCount = 0;
				my.setTurnRight(0);
				my.setAhead(0);

				return;
			}
			
			double goAngle;
			
			if (distance < D1) goAngle = absoluteBearing + dir * (150 - 0.1 * distance);	// 135 - 110 degree
			else if (distance < D2) goAngle = absoluteBearing + dir * 90;
			else goAngle = absoluteBearing + dir * 80;

			if (isNearWall()) {
				goAngle = absoluteBearing + dir * 80;
			}

			double rr = rand.nextInt(120) - 60;
			int sign = M.sign(rr);
			goAngle += rr * rr / 90 * sign;

			if (distance < 400) {
				if (randDir.nextInt(5) == 0) dir *= -1;
				if (randStop.nextInt(7) == 0) stopCount = 1;
				Point po = M.degree2point(goAngle, randLen.nextInt(100) + 30);
				dstX = my.getX() + po.x;
				dstY = my.getY() + po.y;
				//go center
				double cdx, cdy;
				cdx = fW / 2 - dstX;
				cdy = fH / 2 - dstY;		
				dstX += cdx / 8;
				dstY += cdy / 10;
			} else {
				if (randDir.nextInt(6) == 0) dir *= -1;
				if (randStop.nextInt(5) == 0) stopCount = 1;
				Point po = M.degree2point(goAngle, randLen.nextInt(120) + 50);			
				dstX = my.getX() + po.x;
				dstY = my.getY() + po.y;
			}
				

			avoidCornerOLD();
			correctDestination();
		}
		
		//speed
		my.setMaxVelocity(randSpeed.nextInt(2) + 7);
		my.setGoPos(dstX, dstY);
	}


	//------------------------------------------------------------------
	// noliMeTangere() -- mEE^Q
	//                    ɐG
	//                    GڋߎCs
	//------------------------------------------------------------------
	void noliMeTangere(double absoluteBearing) {
		double goAngle1, goAngle2;
		double dx, dy;
		double d1, d2;
			
		my.setMaxVelocity(8);
			
		double minx, miny, min;		//ǂւ̍ŒZ
		minx = Math.min(my.getX(), fW - my.getX());
		miny = Math.min(my.getY(), fH - my.getY());
		min = Math.min(minx, miny);
			
		
		//ǂɋ߂H
		if (min < 100 && my.isArrived(dstX, dstY)) {
			//Eւ̊pxZo
			goAngle1 = absoluteBearing + 100;
			goAngle2 = absoluteBearing - 100;
			Point po1 = M.degree2point(goAngle1, 80);
			Point po2 = M.degree2point(goAngle2, 80);
		
			//Eǂ炪S֋߂
			dx = fW / 2 - (my.getX() + po1.x);
			dy = fH / 2 - (my.getY() + po1.y);
			d1 = dx*dx + dy*dy;
			
			dx = fW / 2 - (my.getX() + po2.x);
			dy = fH / 2 - (my.getY() + po2.y);
			d2 = dx*dx + dy*dy;
		
			//S֋߂ֈړ
			if (d1 < d2) {
				dstX = my.getX() + po1.x;
				dstY = my.getY() + po1.y;				
			} else {
				dstX = my.getX() + po2.x;
				dstY = my.getY() + po2.y;
			}
		} else {
			//ǂɋ߂ȂƂ
			goAngle1 = absoluteBearing + 120;
			Point po1 = M.degree2point(goAngle1, 80);
			dstX = my.getX() + po1.x;
			dstY = my.getY() + po1.y;
		}
		
		correctDestination();
		my.setGoPos(dstX, dstY);
		return;
	}
	
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	boolean isNearWall() {
		double minx, miny, min;		//ǂւ̍ŒZ
		
		minx = Math.min(my.getX(), fW - my.getX());
		miny = Math.min(my.getY(), fH - my.getY());
		min = Math.min(minx, miny);
		
		if (min < 80) return true;
		return false;
	}
			
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		//setNextPos() ֈڂ
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {		
		my.result.damage();
		my.selecter.damage(e.getPower());
	}
	
	//-------------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//
	//
	//-------------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 80;
		final double REF = 1.73;		//45̓ˊpŔ]
		boolean out = false;
		double dx, dy;
		double slope;
		
		dx = dstX - my.getX();
		dy = dstY - my.getY();
		
		if (dx != 0) slope = dy / dx;
		else slope = 9999999;
		
		if (dstX < MARGIN) {
			dstX = MARGIN;
			//out = true;
			if (slope > -REF || slope < REF) dir *= -1;
			else my.setMaxVelocity(4);
		} else if (fW - dstX < MARGIN) {
		 	dstX = fW - MARGIN;
		 	//out = true;
			if (slope > -REF || slope < REF) dir *= -1;
			else my.setMaxVelocity(4);
		}
		if (dstY < MARGIN) {
			dstY = MARGIN;
			//out = true;
			if (slope > 1.0 / REF || slope < -1.0 / REF) dir *= -1;
			else my.setMaxVelocity(4);
		} else  if (fH - dstY < MARGIN) {
			dstY = fH - MARGIN;
			//out = true;
			if (slope > 1.0 / REF || slope < -1.0 / REF) dir *= -1;
			else my.setMaxVelocity(4);
		}
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	void avoidCornerOLD() {
		int MARGIN = (int)(fW / 5.3);
		int x, y;
		int dx, dy;
		int fW, fH;
		int dd;
		boolean flag = false;
		int dirX = 1, dirY = 1;
		
		fW = (int)this.fW;
		fH = (int)this.fH;
		
		dx = (int)Math.abs(my.getX() - dstX);
		dy = (int)Math.abs(my.getY() - dstY);
		dd = dx - dy;
		
		x = (int)dstX;
		y = (int)dstY;
		
		if (-x+y > fH - MARGIN) {
			//NW
			flag = true;
			if (dd > 0) {
				dirX = -1;
				dirY = -1;
			} else {
				dirX = 1;
				dirY = 1;
			}
		} else if (x+y > 2 * (fW - MARGIN)) {
			//NE
			flag = true;
			if (dd > 0) {
				dirX = 1;
				dirY = -1;
			} else {
				dirX = -1;
				dirY = 1;
			}
		} else if (-x+y < -fW + MARGIN) {
			//SE
			flag = true;
			if (dd > 0) {
				dirX = 1;
				dirY = 1;
			} else {
				dirX = -1;
				dirY = -1;
			}
		} else if (x+y < MARGIN) {
			//SW
			flag = true;
			if (dd > 0) {
				dirX = -1;
				dirY = 1;
			} else {
				dirX = 1;
				dirY = -1;
			}
		}
		
		if (flag) {
			double dis = Math.sqrt(dx*dx + dy*dy);
			dstX = my.getX() + dirX * 1.414 * dis;
			dstY = my.getY() + dirY * 1.414 * dis;	
		}
	}
	
	//------------------------------------------------------------------
	// scannedRobot()
	//
	//
	//------------------------------------------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
		
		double x, y;
		double absoluteBearing = (360 + e.getBearing() + my.getHeading() ) % 360;
		x = my.getX() + Math.cos(Math.toRadians(90-absoluteBearing)) * e.getDistance();
		y = my.getY() + Math.sin(Math.toRadians(90-absoluteBearing)) * e.getDistance();		

		
		my.robotKKZ.gun.put(x, y, e.getDistance(), e.getVelocity(), e.getHeading(), absoluteBearing, my.getTime());
	}
}