package pi;

import java.util.*;

public class Point
{
static double p=Math.PI;
public double x;
public double y;
public Point(double _x,double _y)
	{
	x=_x;
	y=_y;
	}


public static Point conversion_polaires_en_cartsiennes(double distance,double angle)
	{
	double xx=distance*Math.sin(angle);
	double yy=distance*Math.cos(angle);
	return new Point(xx,yy);
	}
		
public static boolean is_not_in_area(double xmax,double ymax,Point a)/* modifier*/
	{
	if(a.x<0 ||a.x>xmax	||a.y<0	||a.y>ymax) return false;
	
	else return true;
	}	


public static boolean is_not_in_area_forbiden(double xmax,double ymax,Point a)
	{
	if(a.x<100 ||a.x>(xmax-100)	||a.y<100	||a.y>(ymax-100)) return false;
	
	else return true;
	}
public static boolean is_not_in_zone(double xmax,double ymax,Point a)
	{
	if(a.x<200 ||a.x>(xmax-200)	||a.y<200	||a.y>(ymax-200)) return false;
	
	else return true;
	}



//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
public static	double NormaliseBearing(double ang) {
		if (ang > p)
			ang -= 2*p;
		if (ang < -p)
			ang += 2*p;
		return ang;
	}
	
	//if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
public static	double NormaliseHeading(double ang) {
		if (ang > 2*p)
			ang -= 2*p;
		if (ang < 0)
			ang += 2*p;
		return ang;
	}

public static Point addition(Point a,Point b)
{
return new Point(a.x+b.x,a.y+b.y);
}
public static void printPoint(Point a)
	{
	System.out.println("");
	System.out.println(a.x+" "+a.y);
	System.out.println("");
	}

public static double getdistance(Point a,Point b )
	{
	double xo = b.x-a.x;
	double yo = b.y-a.y;
	double h = Math.sqrt( xo*xo + yo*yo );
	return h;	
	}
	
public static Point coordonnees_actuelle_absolues_ennemi(Point mes_coordonnes,double distance,double angle_absolu) 	
	{
	return addition(conversion_polaires_en_cartsiennes(distance,angle_absolu) , mes_coordonnes);				
	}	

public static double angle_absolu(Point a,Point b)/*returne angle en radians*/
	{		
	double xo = b.x-a.x;
	double yo = b.y-a.y;				
	double h = getdistance(a,b);
	
	if( xo > 0 && yo > 0 )
		{
		return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 )
		{
		return p - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 )
		{
		return p + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 )
		{
		return 2.0*p - Math.asin( -xo / h );
		}
		return 0;
	}

public static double angleRelatif(Point moi,Point ennPos1,Point ennPos2)
	{
	double angle1=angle_absolu(moi,ennPos1);	
	double angle2=angle_absolu(moi,ennPos2);
	
	if(angle1<angle2)
		{
		if(angle2-angle1<p) return angle2-angle1;
		else return -2*p+angle2-angle1;	
		}
	else
		{
		if(angle1-angle2<p)	return -angle1+angle2;
		else  return 2*p-angle1+angle2;
		}				
	}
	
/*public void moveTo(double angle)
	{
	double r=monRobot.getGunHeadingRadians();
	if(r<angle)
		{
		if(angle-r<p) monRobot.setTurnGunRightRadians(angle-r);
		else monRobot.setTurnGunLeftRadians(2*p-angle+r);	
		}
	else
		{
		if(r-angle<p)	monRobot.setTurnGunLeftRadians(r-angle);
		else			monRobot.setTurnGunRightRadians(2*p-r+angle);
		}
	}*/
		
}

																																																																																																																																
																																																																																																																																																																																																																																																																
																																																																																																																																																																																																																																																																																																																																