package romz.model;

import java.util.ArrayList;
import java.util.List;

import robocode.Bullet;
import romz.model.battlefield.BattleField;
import romz.model.robot.Enemy;
import romz.model.robot.Hero;
import romz.model.wave.Wave;

public class Situation {

	public BattleField battleField = new BattleField();
	public Hero hero = new Hero();
	public Enemy enemy = new Enemy();
	public long time;

	private List<Wave> runningWaves = new ArrayList<Wave>();
	
	public void addWave(Bullet bullet) {
		Wave wave = new Wave(this, bullet);
		runningWaves.add(wave);
	}
	
	public List<Wave> updateWaves() {
		List<Wave> hittingWaves = new ArrayList<Wave>();
		for (int i = 0; i < runningWaves.size(); i++) {
			Wave wave = runningWaves.get(i);
			if (wave.overEnemy(time, enemy)) {
				wave.hit(enemy);
				hittingWaves.add(wave);
				runningWaves.remove(i);
			}
		}
		return hittingWaves;
	}

}
