package jam;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.util.*;
import java.io.*;
import java.util.zip.*;
import jam.utils.jUtil;

public class Gun {


    double bearingDirection = 1, lastLatVel, lastVelocity, lastReverseTime, circleDir = 1, enemyFirePower, enemyEnergy, enemyDistance, lastVChangeTime, enemyLatVel, enemyVelocity, enemyFireTime, numBadHits;
    Point2D.Double enemyLocation;
    Point2D.Double robotLocation;
    static final int GF_ZERO = 12;
    static final int GF_ONE = 2*GF_ZERO;
    boolean active = true;
    int fired = 0;
    double myEFired = 0;

    static final double WALL_INDEXES = 3;
    double[][][][][][] guessFactors = new double[3][5][3][3][6][GF_ONE+1];

    ArrayList waves = new ArrayList();

    Rectangle2D.Double BF;
    AdvancedRobot me;

    public Gun(AdvancedRobot a){
        me = a;
        BF = new Rectangle2D.Double(18, 18, me.getBattleFieldWidth() - 36, me.getBattleFieldHeight() - 36);
    }
    public void newRound(){
        waves.clear();
    }
    public void onScannedRobot(ScannedRobotEvent e) {

        robotLocation = new Point2D.Double(me.getX(), me.getY());
        double theta;
        double enemyAbsoluteBearing = me.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = jUtil.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy = e.getEnergy();


        /* ---- Wave Updates ----*/

        for (Iterator it = waves.iterator(); it.hasNext();){
            MicroWave w = (MicroWave)it.next();
            if (w.test(enemyLocation))
                it.remove();
        }

        /* ------------- Fire control ------- */

        /*
            To explain the below; if the enemy's absolute acceleration is
            zero then we segment on time since last velocity change, lateral
            acceleration and lateral velocity.
            If their absolute acceleration is non zero then we segment on absolute
            acceleration and absolute velocity.
            Regardless we segment on walls (near/far approach to walls) and distance.
            I'm trying to have my cake and eat it, basically. :-)
        */
        MicroWave w = new MicroWave();

        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyLatVel = (enemyVelocity = e.getVelocity())*Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);

        int distanceIndex = Math.min(5, (int)enemyDistance/140);

        double bulletPower = distanceIndex == 0 ? 3 : 2;
        theta = Math.min(me.getEnergy()/4, Math.min(enemyEnergy/4, bulletPower));
        if (theta == bulletPower)
            waves.add(w);
        bulletPower = theta;
        w.bulletVelocity = jUtil.bulletVelocity(bulletPower);

        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));

        if (enemyLatVel != 0)
            bearingDirection = enemyLatVel > 0 ? 1 : -1;
        w.bearingDirection = bearingDirection*jUtil.maxEscapeAngle(w.bulletVelocity)/GF_ZERO;

        double moveTime = w.bulletVelocity*lastVChangeTime++/enemyDistance;
        int bestGF = moveTime < .1 ? 1 : moveTime < .3 ? 2 : moveTime < 1 ? 3 : 4;

        int vIndex = (int)Math.abs(enemyLatVel/3);

        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > .6){
            lastVChangeTime = 0;
            bestGF = 0;

            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity/3);
        }

        if (accelIndex != 0)
            accelIndex = accelIndex > 0 ? 1 : 2;

        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        int wallIndex = BF.contains(jUtil.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection*GF_ZERO, enemyDistance)) ? 0 : BF.contains(jUtil.projectMotion(robotLocation, enemyAbsoluteBearing + .5*w.bearingDirection*GF_ZERO, enemyDistance)) ? 1 : 2;

        w.waveGuessFactors = guessFactors[accelIndex][bestGF][vIndex][wallIndex][distanceIndex];

        if (active){
            bestGF = GF_ZERO;

            if (enemyEnergy > 0)
                bestGF = getBestGF(w.waveGuessFactors, enemyDistance);

            me.setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - me.getGunHeadingRadians() + w.bearingDirection*(bestGF-GF_ZERO) ));

            if (me.getEnergy() > 1 || distanceIndex == 0)
                if (me.getGunHeat() == 0){
                    fired++;
                    myEFired += bulletPower;
                }
                me.setFire(bulletPower);
        }
    }

    public int getBestGF(double[] gfs, double distance){
        int bestGF = GF_ZERO;
        double bestVal = 0;
        int halfWidth = (int)Math.floor(Math.atan(18d/distance)*GF_ONE);
        for (int gf = GF_ONE; gf > 0; gf--){
            double tmp = 0;
            for (int i = Math.max(1, gf-halfWidth); i <= Math.min(gf+halfWidth, GF_ONE); i++){
                tmp += gfs[i];
                if (tmp > bestVal){
                    bestGF = gf;
                    bestVal = tmp;
                }
            }
        }
        return bestGF;
    }

    public void loadData(String eName){
        try{
            Object o = jUtil.restoreObject(me.getDataFile(eName));
            byte[][][][][] crib = (byte[][][][][])o;
            convertCribSheet(crib);
        } catch (Exception e){me.out.println("Unable to load data.");}
    }

    public void saveData(String eName){

        jUtil.saveObject(getCribSheet(), me.getDataFile(eName));

    }

    public byte[][][][][] getCribSheet(){
        byte[][][][][] crib = new byte[3][5][3][3][6];
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < 5; j++)
                for (int k = 0; k < 3; k++)
                    for (int l = 0; l < 3; l++)
                        for (int m = 0; m < 6; m++){
                            crib[i][j][k][l][m] = (byte)getBestGF(guessFactors[i][j][k][l][m], 140*m + 70);

                        }
        return crib;
    }


    public void convertCribSheet(byte[][][][][] crib){

        for (int i = 0; i < 3; i++)
            for (int j = 0; j < 5; j++)
                for (int k = 0; k < 3; k++)
                    for (int l = 0; l < 3; l++)
                        for (int m = 0; m < 6; m++)
                            guessFactors[i][j][k][l][m][(int)crib[i][j][k][l][m]] += 15;

    }

    public void setActivity(boolean b){

        active = b;
    }

    class MicroWave
    {

        Point2D.Double firePosition;
        double[] waveGuessFactors;
        double enemyAbsBearing, distance, bearingDirection, bulletVelocity;

        public boolean test(Point2D.Double enemyLocation){

            if (enemyLocation.distance(firePosition) <= (distance+=bulletVelocity) + bulletVelocity){
                int gf = (int)Math.round((Utils.normalRelativeAngle(jUtil.absoluteBearing(firePosition, enemyLocation) - enemyAbsBearing))/bearingDirection + GF_ZERO);
                gf = Math.min(GF_ONE, Math.max(1, gf));
                    //for (int i = GF_ONE; i > 0; i--)
                        //waveGuessFactors[i] = (waveGuessFactors[0]*waveGuessFactors[i] + (i == gf ? 1 : 0))/(waveGuessFactors[0] + 1);
                waveGuessFactors[gf]++;
                waveGuessFactors[0]++;


                return true;
            }
            return false;
        }
    }
}
